/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.DOMWidget;
import com.twosigma.beakerx.widget.SparkManager;
import com.twosigma.beakerx.widget.SparkUIManager;
import com.twosigma.beakerx.widget.Text;
import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.Widget;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.spark.sql.SparkSession;

public class SparkUI
extends VBox {
    public static final String SPARK_EXTRA_LISTENERS = "spark.extraListeners";
    public static final String VIEW_NAME_VALUE = "SparkUIView";
    public static final String MODEL_NAME_VALUE = "SparkUIModel";
    public static final String BEAKERX_ID = "beakerx.id";
    private final SparkUIManager sparkUIManager;
    private VBox vBox;
    private Button connectButton;

    private static SparkUI create(SparkManager sparkManager) {
        return new SparkUI(sparkManager);
    }

    private SparkUI(SparkManager sparkManager) {
        super(new ArrayList());
        this.configureSparkSessionBuilder(sparkManager.getBuilder());
        this.vBox = new VBox(new ArrayList());
        this.add((Widget)this.vBox);
        this.sparkUIManager = new SparkUIManager(this, sparkManager);
    }

    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public String getModelModuleValue() {
        return "beakerx";
    }

    public String getViewModuleValue() {
        return "beakerx";
    }

    private SparkSession.Builder configureSparkSessionBuilder(SparkSession.Builder builder) {
        builder.config(SPARK_EXTRA_LISTENERS, "com.twosigma.beakerx.widget.StartStopSparkListener");
        builder.config(BEAKERX_ID, UUID.randomUUID().toString());
        return builder;
    }

    public boolean isSparkSessionIsActive() {
        return this.sparkUIManager.isActive();
    }

    public void addMasterUrl(Text masterURL) {
        this.vBox.add((Widget)masterURL);
    }

    public void addExecutorCores(Text executorCores) {
        this.vBox.add((Widget)executorCores);
    }

    public void addExecutorMemory(Text executorMemory) {
        this.vBox.add((Widget)executorMemory);
    }

    public void addConnectButton(Button connect) {
        this.connectButton = connect;
        this.vBox.add((Widget)this.connectButton);
    }

    public void clearView() {
        this.removeDOMWidget((DOMWidget)this.vBox);
        this.connectButton = null;
        this.vBox = new VBox(new ArrayList());
        this.add((Widget)this.vBox);
    }

    public Button getConnectButton() {
        return this.connectButton;
    }

    public static class SparkUIFactoryImpl
    implements SparkUIFactory {
        @Override
        public SparkUI create(SparkManager sparkManager) {
            return SparkUI.create(sparkManager);
        }
    }

    public static interface SparkUIFactory {
        public SparkUI create(SparkManager var1);
    }
}

