/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.threads;

import com.twosigma.beakerx.jvm.threads.BeakerOutputHandler;
import com.twosigma.beakerx.widget.OutputManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class BeakerStdOutErrHandler {
    private static BeakerStdOutErrHandler instance;
    private PrintStream orig_out;
    private PrintStream orig_err;
    private BeakerOutputHandler out_handler;
    private BeakerOutputHandler err_handler;

    public static synchronized void init() {
        if (instance == null) {
            instance = new BeakerStdOutErrHandler();
            instance.theinit();
        }
    }

    public static synchronized void fini() {
        if (instance != null) {
            instance.thefini();
            instance = null;
        }
    }

    public static synchronized void setOutputHandler(BeakerOutputHandler out, BeakerOutputHandler err) {
        if (instance != null) {
            instance.theSetOutputHandler(out, err);
        }
    }

    public static synchronized void clrOutputHandler() {
        if (instance != null) {
            instance.theClrOutputHandler();
        }
    }

    private void theinit() {
        this.orig_out = System.out;
        this.orig_err = System.err;
        try {
            System.setOut(new PrintStream((OutputStream)new MyOutputStream(true), false, StandardCharsets.UTF_8.name()));
            System.setErr(new PrintStream((OutputStream)new MyOutputStream(false), false, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void thefini() {
        System.setOut(this.orig_out);
        System.setErr(this.orig_err);
    }

    private synchronized void theSetOutputHandler(BeakerOutputHandler out, BeakerOutputHandler err) {
        this.out_handler = out;
        this.err_handler = err;
    }

    private synchronized void theClrOutputHandler() {
        this.out_handler = null;
        this.err_handler = null;
    }

    private synchronized void writeStdout(String text) throws IOException {
        boolean sendStdout = OutputManager.sendStdout(text);
        if (!sendStdout) {
            if (this.out_handler != null) {
                this.out_handler.write(text);
            } else {
                this.orig_out.write(text.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private synchronized void writeStderr(String text) throws IOException {
        boolean sendStderr = OutputManager.sendStderr(text);
        if (!sendStderr) {
            if (this.err_handler != null) {
                this.err_handler.write(text);
            } else {
                this.orig_err.write(text.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private class MyOutputStream
    extends OutputStream {
        private boolean is_out;

        public MyOutputStream(boolean isout) {
            this.is_out = isout;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] ba = new byte[]{(byte)b};
            String s = new String(ba, StandardCharsets.UTF_8);
            this.write(s);
        }

        @Override
        public void write(byte[] b) throws IOException {
            String s = new String(b, StandardCharsets.UTF_8);
            this.write(s);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String s = new String(b, off, len, StandardCharsets.UTF_8);
            this.write(s);
        }

        private void write(String s) throws IOException {
            if (this.is_out) {
                instance.writeStdout(s);
            } else {
                instance.writeStderr(s);
            }
        }
    }
}

