/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.msg;

import java.util.ArrayList;

public class TracebackPrinter {
    private static final String PREFIX = "\u001b[";
    private static final String RED_COLOR = "31";
    private static final String BOLD_DISPLAY = "1";
    private static final String NORMAL_DISPLAY = "0";
    static final String END = "\u001b[0;0m";
    static final String RED_BOLD = "\u001b[1;31m";
    static final String RED = "\u001b[0;31m";
    private static final String COM_TWOSIGMA_BEAKER = "com.twosigma.beaker";

    public static String[] print(String[] input) {
        if (input == null) {
            return new String[0];
        }
        return TracebackPrinter.mark(input);
    }

    private static String[] mark(String[] input) {
        boolean shouldBeBold = true;
        ArrayList<String> ret = new ArrayList<String>();
        for (String line : input) {
            if (line == null) continue;
            if (!line.contains(COM_TWOSIGMA_BEAKER) && shouldBeBold) {
                ret.add(RED_BOLD + line + END);
                continue;
            }
            shouldBeBold = false;
            ret.add(RED + line + END);
        }
        return ret.toArray(new String[0]);
    }
}

