/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandTypesFactory;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddMvnMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class ClasspathResetMagicCommand
implements MagicCommandFunctionality {
    public static final String CLASSPATH_PREFIX = "%classpath";
    public static final String RESET = "reset";
    public static final String CLASSPATH_RESET = "%classpath reset";
    private KernelFunctionality kernel;

    public ClasspathResetMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath(command);
        if (split.length != 2) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. %classpath reset");
        }
        ClasspathAddMvnMagicCommand mvnMagicCommand = MagicCommandTypesFactory.getClasspathAddMvnMagicCommand(this.kernel);
        mvnMagicCommand.resetRepo();
        try {
            FileUtils.deleteQuietly((File)new File(mvnMagicCommand.getCommandParams().getPathToCache()));
            FileUtils.deleteQuietly((File)new File(mvnMagicCommand.getCommandParams().getPathToNotebookJars()));
        }
        catch (Exception e) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, e.getMessage());
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, "Reset done, please restart the kernel.");
    }

    @Override
    public String getMagicCommandName() {
        return CLASSPATH_RESET;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length == 2 && commandParts[0].equals(CLASSPATH_PREFIX) && commandParts[1].equals(RESET);
    }
}

