/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import java.util.Collection;

public class ClasspathAddDynamicMagicCommand
extends ClasspathMagicCommand {
    private static final String ADD = "add";
    private static final String DYNAMIC = "dynamic";
    public static final String CLASSPATH_ADD_DYNAMIC = "%classpath add dynamic";

    public ClasspathAddDynamicMagicCommand(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public String getMagicCommandName() {
        return CLASSPATH_ADD_DYNAMIC;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 2 && commandParts[0].equals("%classpath") && commandParts[1].equals(ADD) && commandParts[2].equals(DYNAMIC);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        SimpleEvaluationObject seo;
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath(command);
        if (split.length < 4) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. %classpath add dynamic");
        }
        String codeToExecute = command.substring(command.indexOf(DYNAMIC) + DYNAMIC.length()).trim();
        TryResult either = this.kernel.executeCode(codeToExecute, seo = PlainCode.createSimpleEvaluationObject(codeToExecute, this.kernel, param.getCode().getMessage(), param.getExecutionCount()));
        if (either.isResult()) {
            try {
                Collection<String> newAddedJars = this.addJars(either.result());
                if (newAddedJars.isEmpty()) {
                    return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
                }
                String textMessage = "Added jar" + (newAddedJars.size() > 1 ? "s: " : ": ") + newAddedJars;
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, textMessage);
            }
            catch (Exception e) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem during execution of %classpath add dynamic : " + e.getMessage());
            }
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem during execution of %classpath add dynamic : " + either.error());
    }

    private Collection<String> addJars(Object path) {
        if (path instanceof String) {
            return this.addJars((String)path);
        }
        if (path instanceof Collection) {
            return this.addJars((Collection)path);
        }
        throw new RuntimeException("Classpath dynamic handles String or Collection.");
    }
}

