/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.kernel.Config;
import com.twosigma.beakerx.kernel.ConfigurationFile;
import com.twosigma.beakerx.message.MessageSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelConfigurationFile
implements ConfigurationFile {
    private static final Logger logger = LoggerFactory.getLogger(KernelConfigurationFile.class);
    private File config;
    private Config configuration;

    public KernelConfigurationFile(String[] args) {
        this.config = this.getConfig(args);
    }

    @Override
    public Config getConfig() {
        if (this.configuration == null) {
            logger.debug("Path to config file : " + this.config.getAbsolutePath());
            this.configuration = MessageSerializer.parse(new String(this.readConfig(), StandardCharsets.UTF_8), Config.class);
            logger.debug("Creating signing hmac with: {}", (Object)this.configuration.getKey());
        }
        return this.configuration;
    }

    private byte[] readConfig() {
        byte[] bytes = new byte[]{};
        try {
            bytes = Files.readAllBytes(this.config.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    private File getConfig(String[] args) {
        File config;
        if (args.length != 1) {
            logger.error("Invalid parameters passed to the Kernel. Expected one parameter, found " + args.length);
            for (String string : args) {
                logger.error(string);
            }
            System.exit(1);
        }
        if (!(config = new File(args[0])).exists()) {
            logger.error("Kernel configuration not found.");
            System.exit(1);
        }
        return config;
    }
}

