/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.categoryplot.CategoryPlot;
import com.twosigma.beakerx.chart.categoryplot.plotitem.CategoryGraphics;
import com.twosigma.beakerx.chart.serializer.AbstractChartSerializer;
import java.io.IOException;
import java.util.List;

public class CategoryPlotSerializer
extends AbstractChartSerializer<CategoryPlot> {
    public static final String GRAPHICS_LIST = "graphics_list";
    public static final String CATEGORY_NAMES = "categoryNames";
    public static final String ORIENTATION = "orientation";
    public static final String CATEGORY_MARGIN = "category_margin";
    public static final String CATEGORY_NAMES_LABEL_ANGLE = "categoryNamesLabelAngle";

    public void serialize(CategoryPlot categoryPlot, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        List<CategoryGraphics> categoryGraphicsList;
        jgen.writeStartObject();
        this.serialize(categoryPlot, jgen);
        List<String> categoryNames = categoryPlot.getCategoryNames();
        if (categoryNames != null) {
            jgen.writeObjectField(CATEGORY_NAMES, categoryNames);
        }
        if ((categoryGraphicsList = categoryPlot.getGraphics()) != null) {
            for (CategoryGraphics categoryGraphics : categoryGraphicsList) {
                categoryGraphics.createItemLabels(categoryPlot);
            }
            jgen.writeObjectField(GRAPHICS_LIST, categoryGraphicsList);
        }
        jgen.writeObjectField(ORIENTATION, (Object)categoryPlot.getOrientation());
        jgen.writeObjectField(CATEGORY_MARGIN, (Object)categoryPlot.getCategoryMargin());
        jgen.writeObjectField(CATEGORY_NAMES_LABEL_ANGLE, (Object)categoryPlot.getCategoryNamesLabelAngle());
        jgen.writeEndObject();
    }
}

