/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.widget.SparkContextManager;
import com.twosigma.beakerx.widget.VBox;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkUI
extends VBox {
    public static final String SPARK_EXTRA_LISTENERS = "spark.extraListeners";
    public static final String VIEW_NAME_VALUE = "SparkUIView";
    public static final String MODEL_NAME_VALUE = "SparkUIModel";
    public static final String BEAKERX_ID = "beakerx.id";

    public static SparkUI create(SparkConf sparkConf) {
        return new SparkUI(SparkSession.builder().config(sparkConf));
    }

    public static SparkUI create(SparkSession.Builder spaBuilder) {
        return new SparkUI(spaBuilder);
    }

    private SparkUI(SparkSession.Builder builder) {
        super(new ArrayList());
        SparkSession.Builder sparkSessionBuilder = this.configureSparkSessionBuilder(builder);
        new SparkContextManager(this, sparkSessionBuilder);
    }

    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public String getModelModuleValue() {
        return "beakerx";
    }

    public String getViewModuleValue() {
        return "beakerx";
    }

    private SparkSession.Builder configureSparkSessionBuilder(SparkSession.Builder builder) {
        builder.config(SPARK_EXTRA_LISTENERS, "com.twosigma.beakerx.widget.StartStopSparkListener");
        builder.config(BEAKERX_ID, UUID.randomUUID().toString());
        return builder;
    }
}

