/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.Display;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.SparkUI;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkMagicCommand
implements MagicCommandFunctionality {
    public static final String SPARK = "%%sparkRunner";
    private KernelFunctionality kernel;

    public SparkMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    public String getMagicCommandName() {
        return SPARK;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject((String)param.getCommandCodeBlock(), (KernelFunctionality)this.kernel, (Message)param.getCode().getMessage(), (int)param.getExecutionCount());
        if (param.getCommandCodeBlock().isEmpty()) {
            InternalVariable.setValue((SimpleEvaluationObject)seo);
            return this.createSparkUI(new SparkConf());
        }
        return this.createSparkUIBasedOnUserSparkConfiguration(param, seo);
    }

    private MagicCommandOutcomeItem createSparkUIBasedOnUserSparkConfiguration(MagicCommandExecutionParam param, SimpleEvaluationObject seo) {
        TryResult either = this.kernel.executeCode(param.getCommandCodeBlock(), seo);
        if (either.isResult()) {
            Object result = either.result();
            if (result instanceof SparkConf) {
                return this.createSparkUI((SparkConf)result);
            }
            if (result instanceof SparkSession.Builder) {
                return this.createSparkUI((SparkSession.Builder)result);
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Body of  %%sparkRunner magic command must return SparkConf object or SparkSession.Builder object");
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem during execution of %%sparkRunner : " + either.error());
    }

    private MagicCommandOutcomeItem createSparkUI(SparkSession.Builder spaBuilder) {
        SparkUI sparkUI = SparkUI.create(spaBuilder);
        return this.displaySparkUI(sparkUI);
    }

    private MagicCommandOutcomeItem displaySparkUI(SparkUI sparkUI) {
        Display.display((Object)((Object)sparkUI));
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
    }

    private MagicCommandOutcomeItem createSparkUI(SparkConf sparkConf) {
        SparkUI sparkUI = SparkUI.create(sparkConf);
        return this.displaySparkUI(sparkUI);
    }
}

