/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.CodeFactory;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.LoadMagicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.scala.magic.command.SparkexJarService;
import java.util.List;
import java.util.Optional;

public class EnableSparkSupportMagicCommand
implements MagicCommandFunctionality {
    public static final String ENABLE_SPARK_SUPPORT = "%%spark";
    private KernelFunctionality kernel;
    private EnableSparkSupportMagicCommandAction command;

    public EnableSparkSupportMagicCommand(KernelFunctionality kernel, SparkexJarService sparkexJarService) {
        this.kernel = kernel;
        this.command = new EnableSparkSupportMagicCommandActionInit(kernel, sparkexJarService);
    }

    public String getMagicCommandName() {
        return ENABLE_SPARK_SUPPORT;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        return this.command.run(param);
    }

    static interface EnableSparkSupportMagicCommandAction {
        public MagicCommandOutcomeItem run(MagicCommandExecutionParam var1);
    }

    class EnableSparkSupportMagicCommandActionInit
    implements EnableSparkSupportMagicCommandAction {
        private KernelFunctionality kernel;
        private SparkexJarService sparkexJarService;

        public EnableSparkSupportMagicCommandActionInit(KernelFunctionality kernel, SparkexJarService sparkexJarService) {
            this.kernel = kernel;
            this.sparkexJarService = sparkexJarService;
        }

        @Override
        public MagicCommandOutcomeItem run(MagicCommandExecutionParam param) {
            MagicCommandOutcomeItem magicCommandOutcomeItem = this.getMagicCommandOutcomeItem(this.kernel, this.sparkexJarService);
            if (magicCommandOutcomeItem.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
                EnableSparkSupportMagicCommand.this.command = new EnableSparkSupportMagicCommandSparkAction();
                return EnableSparkSupportMagicCommand.this.command.run(param);
            }
            return magicCommandOutcomeItem;
        }

        private MagicCommandOutcomeItem getMagicCommandOutcomeItem(KernelFunctionality kernel, SparkexJarService sparkexJarService) {
            MagicCommandOutcomeItem add = sparkexJarService.addSparkexJar(kernel);
            if (!add.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Can not load sparkex.jar");
            }
            MagicCommandOutcomeItem load = this.loadSparkSupportMagicClass();
            if (!load.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Can not load LoadSparkSupportMagicCommand class");
            }
            MagicCommandOutcomeItem magic = this.loadSparkSupportMagic();
            if (!magic.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Can not run LoadSparkSupportMagicCommand. Check if you add spark to path.");
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, "Spark support enabled");
        }

        private MagicCommandOutcomeItem loadSparkSupportMagic() {
            String loadSparkMagic = "%loadSparkSupport";
            Optional magic = CodeFactory.findMagicCommandFunctionality((List)this.kernel.getMagicCommandTypes(), (String)loadSparkMagic);
            MagicCommandOutcomeItem execute = ((MagicCommandFunctionality)magic.get()).execute(new MagicCommandExecutionParam(null, null, 1, null, false));
            return execute;
        }

        private MagicCommandOutcomeItem loadSparkSupportMagicClass() {
            Optional magic = CodeFactory.findMagicCommandFunctionality((List)this.kernel.getMagicCommandTypes(), (String)"%load_magic");
            MagicCommandOutcomeItem magicCommandOutcomeItem = ((LoadMagicMagicCommand)magic.get()).load("com.twosigma.beakerx.scala.magic.command.LoadSparkSupportMagicCommand");
            return magicCommandOutcomeItem;
        }
    }

    class EnableSparkSupportMagicCommandSparkAction
    implements EnableSparkSupportMagicCommandAction {
        EnableSparkSupportMagicCommandSparkAction() {
        }

        @Override
        public MagicCommandOutcomeItem run(MagicCommandExecutionParam param) {
            String loadSparkMagic = "%%sparkRunner";
            Optional magic = CodeFactory.findMagicCommandFunctionality((List)EnableSparkSupportMagicCommand.this.kernel.getMagicCommandTypes(), (String)loadSparkMagic);
            return ((MagicCommandFunctionality)magic.get()).execute(param);
        }
    }
}

