/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.SmartFMap;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ObservableBindingTrace
implements BindingTrace {
    private final BindingTrace originalTrace;
    private SmartFMap<WritableSlice, RecordHandler> handlers = SmartFMap.emptyMap();

    public ObservableBindingTrace(BindingTrace originalTrace) {
        this.originalTrace = originalTrace;
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        this.originalTrace.report(diagnostic);
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        return this.originalTrace.getBindingContext();
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
        this.originalTrace.record(slice, key, value);
        RecordHandler recordHandler = this.handlers.get(slice);
        if (recordHandler != null) {
            recordHandler.handleRecord(slice, key, value);
        }
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return this.originalTrace.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        return this.originalTrace.getKeys(slice);
    }

    @Override
    @Nullable
    public KotlinType getType(@NotNull KtExpression expression2) {
        return this.originalTrace.getType(expression2);
    }

    @Override
    public void recordType(@NotNull KtExpression expression2, @Nullable KotlinType type2) {
        this.originalTrace.recordType(expression2, type2);
    }

    public <K, V> ObservableBindingTrace addHandler(@NotNull WritableSlice<K, V> slice, @NotNull RecordHandler<K, V> handler2) {
        this.handlers = this.handlers.plus(slice, handler2);
        return this;
    }

    @Override
    public boolean wantsDiagnostics() {
        return this.originalTrace.wantsDiagnostics();
    }

    public static interface RecordHandler<K, V> {
        public void handleRecord(WritableSlice<K, V> var1, K var2, V var3);
    }
}

