/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.FunctionalExpressionElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ReplaceExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public class MethodReferenceElementType
extends FunctionalExpressionElementType<PsiMethodReferenceExpression> {
    private static final NotNullLazyValue<TokenSet> EXCLUDE_FROM_PRESENTABLE_TEXT = new NotNullLazyValue<TokenSet>(){

        @Override
        @NotNull
        protected TokenSet compute() {
            TokenSet tokenSet = TokenSet.orSet(ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET, TokenSet.create(JavaElementType.REFERENCE_PARAMETER_LIST));
            if (tokenSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/MethodReferenceElementType$1", "compute"));
            }
            return tokenSet;
        }
    };

    public MethodReferenceElementType() {
        super("METHOD_REF_EXPRESSION");
    }

    @Override
    public PsiMethodReferenceExpression createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/MethodReferenceElementType", "createPsi"));
        }
        return new PsiMethodReferenceExpressionImpl(node);
    }

    @Override
    public PsiMethodReferenceExpression createPsi(@NotNull FunctionalExpressionStub<PsiMethodReferenceExpression> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/MethodReferenceElementType", "createPsi"));
        }
        return new PsiMethodReferenceExpressionImpl(stub);
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        CompositeElement compositeElement = new CompositeElement(this){

            @Override
            public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
                boolean needParenth;
                if (child == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/MethodReferenceElementType$2", "replaceChildInternal"));
                }
                if (newElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/MethodReferenceElementType$2", "replaceChildInternal"));
                }
                if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType()) && ElementType.EXPRESSION_BIT_SET.contains(newElement.getElementType()) && (needParenth = ReplaceExpressionUtil.isNeedParenthesis(child, newElement))) {
                    newElement = JavaSourceUtil.addParenthToReplacedChild(JavaElementType.PARENTH_EXPRESSION, newElement, this.getManager());
                }
                super.replaceChildInternal(child, newElement);
            }

            @Override
            public int getChildRole(ASTNode child) {
                IElementType elType = child.getElementType();
                if (elType == JavaTokenType.DOUBLE_COLON) {
                    return 253;
                }
                if (elType == JavaTokenType.IDENTIFIER) {
                    return 53;
                }
                if (elType == JavaElementType.REFERENCE_EXPRESSION) {
                    return 119;
                }
                return 64;
            }
        };
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/MethodReferenceElementType", "createCompositeNode"));
        }
        return compositeElement;
    }

    @Override
    @NotNull
    protected String getPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode funExpr) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/MethodReferenceElementType", "getPresentableText"));
        }
        if (funExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funExpr", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/MethodReferenceElementType", "getPresentableText"));
        }
        String string = LightTreeUtil.toFilteredString(tree, funExpr, EXCLUDE_FROM_PRESENTABLE_TEXT.getValue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/MethodReferenceElementType", "getPresentableText"));
        }
        return string;
    }
}

