/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.magic.command;

import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import java.util.HashMap;

public class DataSourcesMagicCommand
implements MagicCommandFunctionality {
    public static final String DATASOURCES = "%datasources";
    private KernelFunctionality kernel;

    public DataSourcesMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        return this.dataSource(DATASOURCES, param.getCommand());
    }

    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath((String)command);
        return commandParts.length > 0 && commandParts[0].equals(DATASOURCES);
    }

    public String getMagicCommandName() {
        return DATASOURCES;
    }

    protected MagicCommandOutcomeItem dataSource(String source, String command) {
        String[] parts = command.split(" ");
        if (parts.length != 2) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. ");
        }
        if (!parts[1].contains("jdbc:")) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Incorrect jdbc url.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(source, parts[1]);
        this.kernel.setShellOptions(new EvaluatorParameters(params));
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
    }
}

