/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.sql.evaluator.SQLCodeRunner;
import com.twosigma.beakerx.sql.evaluator.SQLEvaluator;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SQLWorkerThread
implements Callable<TryResult> {
    private static final Logger logger = LoggerFactory.getLogger((String)SQLWorkerThread.class.getName());
    private SQLEvaluator sqlEvaluator;
    private final JobDescriptor job;

    SQLWorkerThread(SQLEvaluator sqlEvaluator, JobDescriptor j) {
        this.sqlEvaluator = sqlEvaluator;
        this.job = j;
    }

    @Override
    public TryResult call() throws Exception {
        TryResult r;
        NamespaceClient namespaceClient = null;
        this.job.getSimpleEvaluationObject().started();
        try {
            this.job.getSimpleEvaluationObject().setOutputHandler();
            namespaceClient = NamespaceClient.getBeaker((String)this.sqlEvaluator.getSessionId());
            namespaceClient.setOutputObj(this.job.getSimpleEvaluationObject());
            r = this.sqlEvaluator.executeTask(new SQLCodeRunner(this.sqlEvaluator, this.job.getSimpleEvaluationObject(), namespaceClient));
        }
        finally {
            this.job.getSimpleEvaluationObject().clrOutputHandler();
            if (namespaceClient != null) {
                namespaceClient.setOutputObj(null);
            }
        }
        return r;
    }

    public void doExit() {
    }
}

