/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteCandidate;
import com.twosigma.beakerx.autocomplete.AutocompleteRegistry;
import com.twosigma.beakerx.autocomplete.ClassUtils;
import com.twosigma.beakerx.javash.autocomplete.AutocompleteJavaResult;
import com.twosigma.beakerx.javash.autocomplete.JavaAbstractListener;
import com.twosigma.beakerx.javash.autocomplete.JavaParser;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;

public class JavaNodeCompletion
extends JavaAbstractListener {
    private AutocompleteRegistry registry;
    private int cursor;
    private String text;
    private ClassUtils classUtils;

    public JavaNodeCompletion(String t, int c, AutocompleteRegistry r, ClassUtils cu) {
        this.cursor = c;
        this.text = t;
        this.registry = r;
        this.classUtils = cu;
    }

    @Override
    public void visitErrorNode(ErrorNode arg0) {
        JavaParser.CompilationUnitContext cuc;
        if (arg0.getText().equals("new")) {
            cuc = (JavaParser.CompilationUnitContext)arg0.getParent();
            List children = cuc.children;
            int tokenIndex = arg0.getSymbol().getTokenIndex();
            if (tokenIndex - 2 >= 0 && tokenIndex + 1 <= children.size()) {
                ParseTree variablePT = (ParseTree)children.get(tokenIndex - 2);
                ParseTree typePT = (ParseTree)children.get(tokenIndex + 1);
                String type = typePT.getText();
                String variable = variablePT.getText();
                AutocompleteCandidate c1 = new AutocompleteCandidate(3, variable);
                this.registry.addCandidate(c1);
                if (type != null) {
                    this.classUtils.defineVariable(variable, type);
                }
                return;
            }
        }
        if (arg0.getSymbol().getStartIndex() < this.cursor && arg0.getSymbol().getStopIndex() + 1 >= this.cursor) {
            AutocompleteCandidate c;
            if (arg0.getParent() instanceof JavaParser.CompilationUnitContext) {
                cuc = (JavaParser.CompilationUnitContext)arg0.getParent();
                AutocompleteCandidate c2 = new AutocompleteCandidate(7, arg0.getText());
                this.addQuery(c2, this.cursor);
                AutocompleteCandidate c22 = new AutocompleteCandidate(8, arg0.getText());
                this.addQuery(c22, this.cursor);
                this.completeClassFromPath(cuc, arg0.getText());
                return;
            }
            if (arg0.getParent() instanceof JavaParser.BlockStatementContext) {
                if (!arg0.getSymbol().getText().equals(".")) {
                    c = new AutocompleteCandidate(9, arg0.getText());
                    this.addQuery(c, this.cursor);
                    c = new AutocompleteCandidate(4, arg0.getText());
                    this.addQuery(c, this.cursor);
                    c = new AutocompleteCandidate(6, arg0.getText());
                    this.addQuery(c, this.cursor);
                    c = new AutocompleteCandidate(3, arg0.getText());
                    this.addQuery(c, this.cursor);
                } else {
                    JavaParser.BlockStatementContext bs = (JavaParser.BlockStatementContext)arg0.getParent();
                    if (bs.getChildCount() > 1) {
                        String string = bs.getText();
                        this.classUtils.getClass();
                        this.addQuery(this.classUtils.expandExpression(string, this.registry, 2), this.cursor);
                    }
                }
            } else if (arg0.getParent() instanceof JavaParser.ExpressionContext) {
                ParseTree chld = arg0.getParent().getChild(arg0.getParent().getChildCount() - 1);
                if (!chld.equals(arg0)) {
                    return;
                }
                String string = arg0.getParent().getText();
                this.classUtils.getClass();
                this.addQuery(this.classUtils.expandExpression(string, this.registry, 1), this.cursor);
            } else if (arg0.getParent() instanceof JavaParser.TypeDeclarationContext && arg0.getParent().getParent() != null && arg0.getParent().getParent() instanceof JavaParser.CompilationUnitContext) {
                c = new AutocompleteCandidate(8, arg0.getText());
                this.addQuery(c, this.cursor);
            } else if (arg0.getParent() instanceof JavaParser.MemberDeclarationContext && arg0.getParent().getParent() != null && arg0.getParent().getParent() instanceof JavaParser.ClassBodyDeclarationContext && arg0.getParent().getParent().getParent() != null && arg0.getParent().getParent().getParent() instanceof JavaParser.ClassBodyContext && arg0.getParent().getParent().getParent().getText().trim().startsWith("<missing '{'>")) {
                c = new AutocompleteCandidate(11, arg0.getText());
                this.addQuery(c, this.cursor);
            } else if (arg0.getParent() instanceof JavaParser.MemberDeclarationContext && arg0.getParent().getParent() != null && arg0.getParent().getParent() instanceof JavaParser.ClassBodyDeclarationContext && arg0.getParent().getParent().getParent() != null && arg0.getParent().getParent().getParent() instanceof JavaParser.ClassBodyContext) {
                c = new AutocompleteCandidate(4, arg0.getText());
                this.addQuery(c, this.cursor);
                c = new AutocompleteCandidate(6, arg0.getText());
                this.addQuery(c, this.cursor);
            }
        }
    }

    private void completeClassFromPath(JavaParser.CompilationUnitContext ctx, String text) {
        if (!(text = text.substring(text.lastIndexOf(".") + 1, text.length())).isEmpty()) {
            AutocompleteCandidate cName = new AutocompleteCandidate(5, text);
            this.addQuery(cName, AutocompleteJavaResult.getStartIndex(ctx));
        }
    }

    @Override
    public void exitMemberDeclaration(JavaParser.MemberDeclarationContext ctx) {
        if (ctx.getStart().getStartIndex() < this.cursor && ctx.getStop().getStopIndex() + 1 >= this.cursor) {
            String txt = ctx.getText();
            if (txt.contains(" ")) {
                return;
            }
            AutocompleteCandidate c = new AutocompleteCandidate(10, txt);
            this.addQuery(c, AutocompleteJavaResult.getStartIndex(ctx));
        }
    }

    @Override
    public void exitType(JavaParser.TypeContext ctx) {
        if (ctx.getStart().getStartIndex() < this.cursor && ctx.getStop().getStopIndex() + 1 >= this.cursor) {
            String txt = ctx.getText();
            if (txt.contains(" ")) {
                return;
            }
            if (txt.contains(".")) {
                String[] txtv = txt.split("\\.");
                AutocompleteCandidate c = new AutocompleteCandidate(5, txtv);
                this.addQuery(c, AutocompleteJavaResult.getStartIndex(ctx));
            } else {
                AutocompleteCandidate c = new AutocompleteCandidate(4, txt);
                this.addQuery(c, AutocompleteJavaResult.getStartIndex(ctx));
                c = new AutocompleteCandidate(6, txt);
                this.addQuery(c, AutocompleteJavaResult.getStartIndex(ctx));
            }
        }
    }

    @Override
    public void exitExpression(JavaParser.ExpressionContext ctx) {
        if (ctx.getStart().getStartIndex() < this.cursor && ctx.getStop().getStopIndex() + 1 >= this.cursor) {
            if (ctx.getChildCount() == 1) {
                String txt = ctx.getText();
                if (txt.contains(" ")) {
                    return;
                }
                if (this.text.charAt(this.cursor - 1) != '.') {
                    if (txt.contains(".")) {
                        String[] txtv = txt.split("\\.");
                        AutocompleteCandidate c = new AutocompleteCandidate(5, txtv);
                        this.addQuery(c, AutocompleteJavaResult.getStartIndex(ctx));
                    } else {
                        AutocompleteCandidate c = new AutocompleteCandidate(3, txt);
                        this.addQuery(c, AutocompleteJavaResult.getStartIndex(ctx));
                        c = new AutocompleteCandidate(6, txt);
                        this.addQuery(c, AutocompleteJavaResult.getStartIndex(ctx));
                        if (txt.startsWith("n")) {
                            c = new AutocompleteCandidate(12, txt);
                            this.addQuery(c, AutocompleteJavaResult.getStartIndex(ctx));
                        }
                    }
                }
            } else {
                String string = ctx.getText();
                this.classUtils.getClass();
                this.addQuery(this.classUtils.expandExpression(string, this.registry, 2), AutocompleteJavaResult.getStartIndex(ctx));
            }
        }
    }

    @Override
    public void exitCreatedName(JavaParser.CreatedNameContext ctx) {
        if (ctx.getStart().getStartIndex() < this.cursor && ctx.getStop().getStopIndex() + 1 >= this.cursor) {
            String txt = ctx.getText();
            if (txt.contains(" ")) {
                return;
            }
            if (this.text.charAt(this.cursor - 1) != '.') {
                if (txt.contains(".")) {
                    String[] txtv = txt.split("\\.");
                    AutocompleteCandidate c = new AutocompleteCandidate(5, txtv);
                    this.addQuery(c, AutocompleteJavaResult.getStartIndex(ctx));
                } else {
                    AutocompleteCandidate c = new AutocompleteCandidate(6, txt);
                    this.addQuery(c, AutocompleteJavaResult.getStartIndex(ctx));
                }
            }
        }
    }

    @Override
    public void exitCompilationUnit(JavaParser.CompilationUnitContext ctx) {
        if (ctx.getStop() != null && ctx.getStop().getStopIndex() + 1 == this.cursor) {
            String t = ctx.getText();
            this.classUtils.getClass();
            this.addQuery(this.classUtils.expandExpression(t, this.registry, 2), this.calculateStartIndex(t, ctx));
            String[] txtv = this.splitByDot(t);
            AutocompleteCandidate c2 = new AutocompleteCandidate(5, txtv);
            this.addQuery(c2, this.calculateStartIndex(t, ctx));
        }
    }

    private String[] splitByDot(String t) {
        String[] txtv;
        if (t.endsWith(".")) {
            txtv = (t + "X").split("\\.");
            txtv[txtv.length - 1] = "";
        } else {
            txtv = t.split("\\.");
        }
        return txtv;
    }

    private int calculateStartIndex(String t, ParserRuleContext ctx) {
        return AutocompleteJavaResult.getStartIndex(ctx) + (t.endsWith(".") ? 1 : 0);
    }
}

