/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteCandidate;
import com.twosigma.beakerx.autocomplete.AutocompleteRegistry;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.ClassUtils;
import com.twosigma.beakerx.javash.autocomplete.AutocompleteRegistryFactory;
import com.twosigma.beakerx.javash.autocomplete.JavaClassUtils;
import com.twosigma.beakerx.javash.autocomplete.JavaClasspathScanner;
import com.twosigma.beakerx.javash.autocomplete.JavaImportDeclarationCompletion;
import com.twosigma.beakerx.javash.autocomplete.JavaLexer;
import com.twosigma.beakerx.javash.autocomplete.JavaNameBuilder;
import com.twosigma.beakerx.javash.autocomplete.JavaNodeCompletion;
import com.twosigma.beakerx.javash.autocomplete.JavaParser;
import com.twosigma.beakerx.kernel.Imports;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class JavaAutocomplete {
    AutocompleteRegistry registry;
    private JavaClasspathScanner cps;
    private List<String> imports;

    public JavaAutocomplete(JavaClasspathScanner _cps) {
        this.cps = _cps;
        this.registry = AutocompleteRegistryFactory.createRegistry(this.cps);
        this.imports = new ArrayList<String>();
    }

    public AutocompleteResult doAutocomplete(String txt, int cur, ClassLoader l, Imports imports) {
        try {
            return this.find(txt, cur, l, imports);
        }
        catch (Exception e) {
            return new AutocompleteResult(new ArrayList(), 0);
        }
    }

    private AutocompleteResult find(String txt, int cur, ClassLoader l, Imports imports) {
        List ret;
        this.registry = AutocompleteRegistryFactory.createRegistry(this.cps);
        ClassUtils cu = this.createClassUtils(l);
        AutocompleteRegistryFactory.setup(cu, this.registry);
        AutocompleteRegistryFactory.addDefaultImports(cu, this.registry, imports.toListOfStrings(), this.cps);
        JavaLexer lexer = new JavaLexer((CharStream)new ANTLRInputStream(txt));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JavaParser parser = new JavaParser((TokenStream)tokens);
        parser.removeErrorListeners();
        JavaParser.CompilationUnitContext t = parser.compilationUnit();
        ParseTreeWalker walker = new ParseTreeWalker();
        ArrayList<AutocompleteCandidate> q = new ArrayList<AutocompleteCandidate>();
        JavaImportDeclarationCompletion extractor = new JavaImportDeclarationCompletion(txt, cur, this.registry, this.cps, cu);
        JavaNameBuilder extractor2 = new JavaNameBuilder(this.registry, cu);
        JavaNodeCompletion extractor3 = new JavaNodeCompletion(txt, cur, this.registry, cu);
        walker.walk((ParseTreeListener)extractor, (ParseTree)t);
        if (extractor.getQuery() != null) {
            q.addAll(extractor.getQuery());
        }
        walker.walk((ParseTreeListener)extractor2, (ParseTree)t);
        walker.walk((ParseTreeListener)extractor3, (ParseTree)t);
        if (extractor3.getQuery() != null) {
            q.addAll(extractor3.getQuery());
        }
        if (!(ret = this.registry.searchCandidates(q)).isEmpty()) {
            return new AutocompleteResult(ret, this.getStartIndex(extractor, extractor2, extractor3));
        }
        return this.findAutocompleteResult(txt, cur, cu);
    }

    private AutocompleteResult findAutocompleteResult(String txt, int cur, ClassUtils cu) {
        ArrayList<AutocompleteCandidate> q = new ArrayList<AutocompleteCandidate>();
        List ret = new ArrayList();
        int startIndex = 0;
        for (int i = cur - 1; i >= 0; --i) {
            if (i >= txt.length() || !Character.isWhitespace(txt.charAt(i))) continue;
            String tx = txt.substring(i + 1, cur).trim();
            if (txt.isEmpty()) break;
            if (tx.contains(".")) {
                cu.getClass();
                q.add(cu.expandExpression(tx, this.registry, 2));
            } else {
                q.add(new AutocompleteCandidate(3, tx));
            }
            ret = this.registry.searchCandidates(q);
            startIndex = txt.indexOf(tx) + tx.length();
            break;
        }
        return new AutocompleteResult(ret, startIndex);
    }

    private int getStartIndex(JavaImportDeclarationCompletion extractor, JavaNameBuilder extractor2, JavaNodeCompletion extractor3) {
        if (extractor.getQuery() != null) {
            return extractor.getStartIndex();
        }
        if (extractor2.getQuery() != null) {
            return extractor2.getStartIndex();
        }
        if (extractor3.getQuery() != null) {
            return extractor3.getStartIndex();
        }
        return 0;
    }

    public void addImport(String imp) {
        this.imports.add(imp);
    }

    protected ClassUtils createClassUtils(ClassLoader l) {
        return new JavaClassUtils(this.cps, l);
    }
}

