/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiCachedValueImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiParameterizedCachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.kotlin.com.intellij.util.CachedValuesFactory;

public class PsiCachedValuesFactory
implements CachedValuesFactory {
    private final Project myProject;
    private final PsiManager myManager;

    public PsiCachedValuesFactory(PsiManager manager) {
        this.myManager = manager;
        this.myProject = manager.getProject();
    }

    @Override
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiCachedValuesFactory", "createCachedValue"));
        }
        return trackValue ? new PsiCachedValueImpl<T>(this.myManager, provider){

            @Override
            protected Object[] getDependencies(CachedValueProvider.Result<T> result2) {
                return this.getDependenciesPlusValue(result2);
            }
        } : new PsiCachedValueImpl<T>(this.myManager, provider);
    }

    @Override
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiCachedValuesFactory", "createParameterizedCachedValue"));
        }
        return trackValue ? new PsiParameterizedCachedValue<T, P>(this.myManager, provider){

            @Override
            public boolean isFromMyProject(Project project) {
                return PsiCachedValuesFactory.this.myProject == project;
            }

            @Override
            protected Object[] getDependencies(CachedValueProvider.Result<T> tResult) {
                return this.getDependenciesPlusValue(tResult);
            }
        } : new PsiParameterizedCachedValue<T, P>(this.myManager, provider){

            @Override
            public boolean isFromMyProject(Project project) {
                return PsiCachedValuesFactory.this.myProject == project;
            }
        };
    }
}

