/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.MavenJarResolver;
import com.twosigma.beakerx.kernel.magic.command.functionality.AddImportMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.AddStaticImportMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.BashMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClassPathAddMvnCellMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddDynamicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddJarMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddMvnMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddRepoMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathResetMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathShowMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.HtmlAliasMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.HtmlMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.JSMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.JavaScriptMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.LoadMagicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.LsMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeCellModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeItCellModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeItLineModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeLineModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.UnImportMagicCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class MagicCommandTypesFactory {
    public static List<MagicCommandType> createDefaults(KernelFunctionality kernel) {
        ArrayList<MagicCommandType> magicCommandTypes = new ArrayList<MagicCommandType>();
        magicCommandTypes.addAll(Arrays.asList(MagicCommandTypesFactory.javascript(), MagicCommandTypesFactory.js(), MagicCommandTypesFactory.html(), MagicCommandTypesFactory.HTML(), MagicCommandTypesFactory.bash(), MagicCommandTypesFactory.lsmagic(magicCommandTypes), MagicCommandTypesFactory.addJar(kernel), MagicCommandTypesFactory.addJarByMvn(kernel), MagicCommandTypesFactory.addJarByMvnCell(kernel), MagicCommandTypesFactory.addDynamic(kernel), MagicCommandTypesFactory.addRepo(kernel), MagicCommandTypesFactory.addClasspathReset(kernel), MagicCommandTypesFactory.showClasspath(kernel), MagicCommandTypesFactory.addStaticImport(kernel), MagicCommandTypesFactory.addImport(kernel), MagicCommandTypesFactory.unimport(kernel), MagicCommandTypesFactory.timeLine(kernel), MagicCommandTypesFactory.timeCell(kernel), MagicCommandTypesFactory.timeItLine(kernel), MagicCommandTypesFactory.timeItCell(kernel), MagicCommandTypesFactory.loadMagic(kernel)));
        return magicCommandTypes;
    }

    public static ClasspathAddMvnMagicCommand getClasspathAddMvnMagicCommand(KernelFunctionality kernel) {
        Optional<MagicCommandType> first = kernel.getMagicCommandTypes().stream().filter(x -> x.getCommand().equals("%classpath add mvn")).findFirst();
        return (ClasspathAddMvnMagicCommand)first.get().getMagicCommandFunctionality();
    }

    public static ClasspathResetMagicCommand getClasspathResetMagicCommand(KernelFunctionality kernel) {
        Optional<MagicCommandType> first = kernel.getMagicCommandTypes().stream().filter(x -> x.getCommand().equals("%classpath reset")).findFirst();
        return (ClasspathResetMagicCommand)first.get().getMagicCommandFunctionality();
    }

    private static MagicCommandType addClasspathReset(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath reset", "", new ClasspathResetMagicCommand(kernel));
    }

    private static MagicCommandType addDynamic(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add dynamic", "", new ClasspathAddDynamicMagicCommand(kernel));
    }

    private static MagicCommandType loadMagic(KernelFunctionality kernel) {
        return new MagicCommandType("%load_magic", "", new LoadMagicMagicCommand(kernel));
    }

    private static MagicCommandType timeItCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%timeit", "", new TimeItCellModeMagicCommand(kernel));
    }

    private static MagicCommandType timeItLine(KernelFunctionality kernel) {
        return new MagicCommandType("%timeit", "", new TimeItLineModeMagicCommand(kernel));
    }

    private static MagicCommandType timeCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%time", "", new TimeCellModeMagicCommand(kernel));
    }

    private static MagicCommandType timeLine(KernelFunctionality kernel) {
        return new MagicCommandType("%time", "", new TimeLineModeMagicCommand(kernel));
    }

    private static MagicCommandType unimport(KernelFunctionality kernel) {
        return new MagicCommandType("%unimport", "<classpath>", new UnImportMagicCommand(kernel));
    }

    private static MagicCommandType addImport(KernelFunctionality kernel) {
        return new MagicCommandType("%import", "<classpath>", new AddImportMagicCommand(kernel));
    }

    private static MagicCommandType addStaticImport(KernelFunctionality kernel) {
        return new MagicCommandType("%import static", "<classpath>", new AddStaticImportMagicCommand(kernel));
    }

    private static MagicCommandType showClasspath(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath", "", new ClasspathShowMagicCommand(kernel));
    }

    private static MagicCommandType addJarByMvn(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add mvn", "<group name version>", new ClasspathAddMvnMagicCommand(MagicCommandTypesFactory.getMvnMagicCommandParams(kernel), kernel));
    }

    private static MavenJarResolver.ResolverParams getMvnMagicCommandParams(KernelFunctionality kernel) {
        return new MavenJarResolver.ResolverParams(kernel.getCacheFolder().toString() + "/maven/cache", kernel.getTempFolder().toString() + MavenJarResolver.MVN_DIR);
    }

    private static MagicCommandType addJarByMvnCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%classpath add mvn", "<group name version>", new ClassPathAddMvnCellMagicCommand(MagicCommandTypesFactory.getMvnMagicCommandParams(kernel), kernel));
    }

    private static MagicCommandType addJar(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add jar", "<jar path>", new ClasspathAddJarMagicCommand(kernel));
    }

    private static MagicCommandType addRepo(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath config resolver", "<repoName repoUrl>", new ClasspathAddRepoMagicCommand(kernel));
    }

    private static MagicCommandType lsmagic(List<MagicCommandType> magicCommandTypes) {
        return new MagicCommandType("%lsmagic", "", new LsMagicCommand(magicCommandTypes));
    }

    private static MagicCommandType bash() {
        return new MagicCommandType("%%bash", "", new BashMagicCommand());
    }

    private static MagicCommandType html() {
        return new MagicCommandType("%%html", "", new HtmlMagicCommand());
    }

    private static MagicCommandType HTML() {
        return new MagicCommandType("%%HTML", "", new HtmlAliasMagicCommand());
    }

    private static MagicCommandType javascript() {
        return new MagicCommandType("%%javascript", "", new JavaScriptMagicCommand());
    }

    private static MagicCommandType js() {
        return new MagicCommandType("%%js", "", new JSMagicCommand());
    }
}

