/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.OptionalLong;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.OptionalShouldBeEmpty;
import org.assertj.core.error.OptionalShouldBePresent;
import org.assertj.core.error.OptionalShouldContain;

public abstract class AbstractOptionalLongAssert<S extends AbstractOptionalLongAssert<S>>
extends AbstractAssert<S, OptionalLong> {
    protected AbstractOptionalLongAssert(OptionalLong actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isPresent() {
        this.isNotNull();
        if (!((OptionalLong)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBePresent.shouldBePresent(this.actual));
        }
        return (S)((AbstractOptionalLongAssert)this.myself);
    }

    public S isNotPresent() {
        return this.isEmpty();
    }

    public S isEmpty() {
        this.isNotNull();
        if (((OptionalLong)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBeEmpty.shouldBeEmpty((OptionalLong)this.actual));
        }
        return (S)((AbstractOptionalLongAssert)this.myself);
    }

    public S isNotEmpty() {
        return this.isPresent();
    }

    public S hasValue(long expectedValue) {
        this.isNotNull();
        if (!((OptionalLong)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (expectedValue != ((OptionalLong)this.actual).getAsLong()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain((OptionalLong)this.actual, expectedValue));
        }
        return (S)((AbstractOptionalLongAssert)this.myself);
    }
}

