/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.injected.editor.VirtualFileWindow;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileManager;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

class EmptyFileManager
implements FileManager {
    private final PsiManagerImpl myManager;
    private final ConcurrentMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = ContainerUtil.createConcurrentWeakValueMap();

    EmptyFileManager(PsiManagerImpl manager) {
        this.myManager = manager;
    }

    @Override
    public void dispose() {
    }

    @Override
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/impl/EmptyFileManager", "findFile"));
        }
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider == null ? null : viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/impl/EmptyFileManager", "findDirectory"));
        }
        return null;
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/EmptyFileManager", "reloadFromDisk"));
        }
    }

    @Override
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/psi/impl/EmptyFileManager", "getCachedPsiFile"));
        }
        return null;
    }

    @Override
    public void cleanupForNextTest() {
        this.myVFileToViewProviderMap.clear();
    }

    @Override
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/EmptyFileManager", "findViewProvider"));
        }
        return (FileViewProvider)this.myVFileToViewProviderMap.get(file2);
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/EmptyFileManager", "findCachedViewProvider"));
        }
        return (FileViewProvider)this.myVFileToViewProviderMap.get(file2);
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, boolean eventSystemEnabled) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/EmptyFileManager", "createFileViewProvider"));
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, file2, eventSystemEnabled);
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/EmptyFileManager", "createFileViewProvider"));
        }
        return singleRootFileViewProvider;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile2, FileViewProvider singleRootFileViewProvider) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/impl/EmptyFileManager", "setViewProvider"));
        }
        if (!(virtualFile2 instanceof VirtualFileWindow)) {
            if (singleRootFileViewProvider == null) {
                this.myVFileToViewProviderMap.remove(virtualFile2);
            } else {
                this.myVFileToViewProviderMap.put(virtualFile2, singleRootFileViewProvider);
            }
        }
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        List<PsiFile> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/EmptyFileManager", "getAllCachedFiles"));
        }
        return list2;
    }
}

