/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.AbstractBundle;
import org.jetbrains.kotlin.com.intellij.CommonBundle;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.ide.plugins.HelpSetPath;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginBean;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginDependency;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginHelpSet;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.ComponentConfig;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import org.jetbrains.kotlin.com.intellij.openapi.util.InvalidDataException;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.NullableLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.containers.StringInterner;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMXIncluder;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializer;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.org.jdom.Document;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.JDOMException;

public class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.plugins.PluginDescriptor");
    private final NullableLazyValue<String> myDescription;
    private String myName;
    private PluginId myId;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myVendorLogoPath;
    private String myCategory;
    private String url;
    private File myPath;
    private PluginId[] myDependencies;
    private PluginId[] myOptionalDependencies;
    private Map<PluginId, String> myOptionalConfigs;
    private Map<PluginId, IdeaPluginDescriptorImpl> myOptionalDescriptors;
    @Nullable
    private List<Element> myActionsElements;
    private ComponentConfig[] myAppComponents;
    private ComponentConfig[] myProjectComponents;
    private ComponentConfig[] myModuleComponents;
    private ClassLoader myLoader;
    private HelpSetPath[] myHelpSets;
    @Nullable
    private MultiMap<String, Element> myExtensions;
    @Nullable
    private MultiMap<String, Element> myExtensionsPoints;
    private String myDescriptionChildText;
    private boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    private boolean myAllowBundledUpdate;
    private boolean myEnabled;
    private String mySinceBuild;
    private String myUntilBuild;
    private List<String> myModules;
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    public IdeaPluginDescriptorImpl(@NotNull File pluginPath) {
        if (pluginPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginPath", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "<init>"));
        }
        this.myDescription = new NullableLazyValue<String>(){

            @Override
            protected String compute() {
                return IdeaPluginDescriptorImpl.this.computeDescription();
            }
        };
        this.myDependencies = PluginId.EMPTY_ARRAY;
        this.myOptionalDependencies = PluginId.EMPTY_ARRAY;
        this.myEnabled = true;
        this.myPath = pluginPath;
    }

    @Nullable
    private static List<Element> copyElements(@Nullable Element[] elements, StringInterner interner) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        SmartList<Element> result2 = new SmartList<Element>();
        for (Element extensionsRoot : elements) {
            for (Element element : extensionsRoot.getChildren()) {
                JDOMUtil.internElement(element, interner);
                result2.add(element);
            }
        }
        return result2;
    }

    private static String createDescriptionKey(PluginId id) {
        return "plugin." + id + ".description";
    }

    private static ComponentConfig[] mergeComponents(ComponentConfig[] first, ComponentConfig[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return ArrayUtil.mergeArrays(first, second);
    }

    @Override
    public File getPath() {
        return this.myPath;
    }

    public void setPath(@NotNull File path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "setPath"));
        }
        this.myPath = path2;
    }

    public void readExternal(@NotNull Document document, @NotNull URL url, @NotNull JDOMXIncluder.PathResolver pathResolver) throws InvalidDataException, FileNotFoundException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        if (pathResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathResolver", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        Application application = ApplicationManager.getApplication();
        this.readExternal(document, url, application != null && application.isUnitTestMode(), pathResolver);
    }

    public void readExternal(@NotNull Document document, @NotNull URL url, boolean ignoreMissingInclude, @NotNull JDOMXIncluder.PathResolver pathResolver) throws InvalidDataException, FileNotFoundException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        if (pathResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathResolver", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        document = JDOMXIncluder.resolve(document, url.toExternalForm(), ignoreMissingInclude, pathResolver);
        Element rootElement = document.getRootElement();
        JDOMUtil.internElement(rootElement, new StringInterner());
        this.readExternal(document.getRootElement());
    }

    public void readExternal(@NotNull URL url) throws InvalidDataException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        try {
            Document document = JDOMUtil.loadDocument(url);
            this.readExternal(document, url, JDOMXIncluder.DEFAULT_PATH_RESOLVER);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException | JDOMException e) {
            throw new InvalidDataException(e);
        }
    }

    protected void readExternal(@NotNull Element element) {
        List<Element> extensionPoints;
        StringInterner interner;
        List<Element> extensions;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        PluginBean pluginBean = XmlSerializer.deserialize(element, PluginBean.class);
        this.url = pluginBean.url;
        this.myName = pluginBean.name;
        String idString = pluginBean.id;
        if (idString == null || idString.isEmpty()) {
            idString = this.myName;
        }
        this.myId = idString == null ? null : PluginId.getId(idString);
        String internalVersionString = pluginBean.formatVersion;
        if (internalVersionString != null) {
            try {
                Integer.parseInt(internalVersionString);
            }
            catch (NumberFormatException e) {
                LOG.error(new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", e, this.myId));
            }
        }
        this.myUseIdeaClassLoader = pluginBean.useIdeaClassLoader;
        this.myAllowBundledUpdate = pluginBean.allowBundledUpdate;
        if (pluginBean.ideaVersion != null) {
            this.mySinceBuild = pluginBean.ideaVersion.sinceBuild;
            this.myUntilBuild = IdeaPluginDescriptorImpl.convertExplicitBigNumberInUntilBuildToStar(pluginBean.ideaVersion.untilBuild);
        }
        this.myResourceBundleBaseName = pluginBean.resourceBundle;
        this.myDescriptionChildText = pluginBean.description;
        this.myChangeNotes = pluginBean.changeNotes;
        this.myVersion = pluginBean.pluginVersion;
        if (this.myVersion == null) {
            this.myVersion = PluginManagerCore.getBuildNumber().asStringWithoutProductCode();
        }
        this.myCategory = pluginBean.category;
        if (pluginBean.vendor != null) {
            this.myVendor = pluginBean.vendor.name;
            this.myVendorEmail = pluginBean.vendor.email;
            this.myVendorUrl = pluginBean.vendor.url;
            this.myVendorLogoPath = pluginBean.vendor.logo;
        }
        LinkedHashSet<PluginId> dependentPlugins = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> optionalDependentPlugins = new LinkedHashSet<PluginId>();
        if (pluginBean.dependencies != null) {
            this.myOptionalConfigs = new THashMap<PluginId, String>();
            for (PluginDependency dependency : pluginBean.dependencies) {
                String text2 = dependency.pluginId;
                if (StringUtil.isEmpty(text2)) continue;
                PluginId id = PluginId.getId(text2);
                dependentPlugins.add(id);
                if (!dependency.optional) continue;
                optionalDependentPlugins.add(id);
                if (StringUtil.isEmpty(dependency.configFile)) continue;
                this.myOptionalConfigs.put(id, dependency.configFile);
            }
        }
        this.myDependencies = dependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : dependentPlugins.toArray(new PluginId[dependentPlugins.size()]);
        PluginId[] pluginIdArray = this.myOptionalDependencies = optionalDependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : optionalDependentPlugins.toArray(new PluginId[optionalDependentPlugins.size()]);
        if (pluginBean.helpSets == null || pluginBean.helpSets.length == 0) {
            this.myHelpSets = HelpSetPath.EMPTY;
        } else {
            this.myHelpSets = new HelpSetPath[pluginBean.helpSets.length];
            for (PluginHelpSet pluginHelpSet : pluginBean.helpSets) {
                this.myHelpSets[i] = new HelpSetPath(pluginHelpSet.file, pluginHelpSet.path);
            }
        }
        this.myAppComponents = pluginBean.applicationComponents;
        this.myProjectComponents = pluginBean.projectComponents;
        this.myModuleComponents = pluginBean.moduleComponents;
        if (this.myAppComponents == null) {
            this.myAppComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myProjectComponents == null) {
            this.myProjectComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myModuleComponents == null) {
            this.myModuleComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if ((extensions = IdeaPluginDescriptorImpl.copyElements(pluginBean.extensions, interner = new StringInterner())) != null) {
            this.myExtensions = MultiMap.createSmart();
            for (Element extension : extensions) {
                this.myExtensions.putValue(ExtensionsAreaImpl.extractEPName(extension), extension);
            }
        }
        if ((extensionPoints = IdeaPluginDescriptorImpl.copyElements(pluginBean.extensionPoints, interner)) != null) {
            this.myExtensionsPoints = MultiMap.createSmart();
            for (Element extensionPoint : extensionPoints) {
                this.myExtensionsPoints.putValue(StringUtil.notNullize(extensionPoint.getAttributeValue("area")), extensionPoint);
            }
        }
        this.myActionsElements = IdeaPluginDescriptorImpl.copyElements(pluginBean.actions, interner);
        if (pluginBean.modules != null && !pluginBean.modules.isEmpty()) {
            this.myModules = pluginBean.modules;
        }
    }

    public static String convertExplicitBigNumberInUntilBuildToStar(@Nullable String build2) {
        if (build2 == null) {
            return null;
        }
        Matcher matcher = EXPLICIT_BIG_NUMBER_PATTERN.matcher(build2);
        if (matcher.matches()) {
            return matcher.group(1) + ".*";
        }
        return build2;
    }

    public void registerExtensionPoints(@NotNull ExtensionsArea area) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "registerExtensionPoints"));
        }
        if (this.myExtensionsPoints != null) {
            for (Element element : this.myExtensionsPoints.get(StringUtil.notNullize(area.getAreaClass()))) {
                area.registerExtensionPoint(this, element);
            }
        }
    }

    public void registerExtensions(@NotNull ExtensionsArea area, @NotNull String epName) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "registerExtensions"));
        }
        if (epName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "epName", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "registerExtensions"));
        }
        if (this.myExtensions != null) {
            for (Element element : this.myExtensions.get(epName)) {
                area.registerExtension(this, element);
            }
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public PluginId[] getDependentPluginIds() {
        if (this.myDependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getDependentPluginIds"));
        }
        return this.myDependencies;
    }

    @Override
    @NotNull
    public PluginId[] getOptionalDependentPluginIds() {
        if (this.myOptionalDependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getOptionalDependentPluginIds"));
        }
        return this.myOptionalDependencies;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public String getCategory() {
        return this.myCategory;
    }

    @NotNull
    public List<File> getClassPath() {
        if (this.myPath.isDirectory()) {
            File[] files2;
            ArrayList<File> result2 = new ArrayList<File>();
            File classesDir = new File(this.myPath, "classes");
            if (classesDir.exists()) {
                result2.add(classesDir);
            }
            if ((files2 = new File(this.myPath, "lib").listFiles()) != null && files2.length > 0) {
                for (File f : files2) {
                    if (f.isFile()) {
                        String name = f.getName();
                        if (!StringUtil.endsWithIgnoreCase(name, ".jar") && !StringUtil.endsWithIgnoreCase(name, ".zip")) continue;
                        result2.add(f);
                        continue;
                    }
                    result2.add(f);
                }
            }
            ArrayList<File> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getClassPath"));
            }
            return arrayList;
        }
        List<File> list2 = Collections.singletonList(this.myPath);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getClassPath"));
        }
        return list2;
    }

    @NonNls
    public String toString() {
        return "PluginDescriptor[name='" + this.myName + "', classpath='" + this.myPath + "']";
    }

    public void setLoader(ClassLoader loader) {
        this.myLoader = loader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeaPluginDescriptorImpl)) {
            return false;
        }
        IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)o;
        return this.myName == null ? pluginDescriptor.myName == null : this.myName.equals(pluginDescriptor.myName);
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    @Override
    public PluginId getPluginId() {
        return this.myId;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    @Override
    public boolean getUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    public boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    public void setUseCoreClassLoader(boolean useCoreClassLoader) {
        this.myUseCoreClassLoader = useCoreClassLoader;
    }

    private String computeDescription() {
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = AbstractBundle.getResourceBundle(this.myResourceBundleBaseName, this.getPluginClassLoader());
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        if (bundle == null) {
            return this.myDescriptionChildText;
        }
        return CommonBundle.messageOrDefault(bundle, IdeaPluginDescriptorImpl.createDescriptionKey(this.myId), this.myDescriptionChildText == null ? "" : this.myDescriptionChildText, new Object[0]);
    }

    public void insertDependency(@NotNull IdeaPluginDescriptor d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "insertDependency"));
        }
        PluginId[] deps = new PluginId[this.getDependentPluginIds().length + 1];
        deps[0] = d.getPluginId();
        System.arraycopy(this.myDependencies, 0, deps, 1, deps.length - 1);
        this.myDependencies = deps;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    @Override
    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    Map<PluginId, String> getOptionalConfigs() {
        return this.myOptionalConfigs;
    }

    Map<PluginId, IdeaPluginDescriptorImpl> getOptionalDescriptors() {
        return this.myOptionalDescriptors;
    }

    void setOptionalDescriptors(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> optionalDescriptors) {
        if (optionalDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionalDescriptors", "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "setOptionalDescriptors"));
        }
        this.myOptionalDescriptors = optionalDescriptors;
    }

    void mergeOptionalConfig(IdeaPluginDescriptorImpl descriptor2) {
        if (this.myExtensions == null) {
            this.myExtensions = descriptor2.myExtensions;
        } else if (descriptor2.myExtensions != null) {
            this.myExtensions.putAllValues(descriptor2.myExtensions);
        }
        if (this.myExtensionsPoints == null) {
            this.myExtensionsPoints = descriptor2.myExtensionsPoints;
        } else if (descriptor2.myExtensionsPoints != null) {
            this.myExtensionsPoints.putAllValues(descriptor2.myExtensionsPoints);
        }
        if (this.myActionsElements == null) {
            this.myActionsElements = descriptor2.myActionsElements;
        } else if (descriptor2.myActionsElements != null) {
            this.myActionsElements.addAll(descriptor2.myActionsElements);
        }
        this.myAppComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myAppComponents, descriptor2.myAppComponents);
        this.myProjectComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myProjectComponents, descriptor2.myProjectComponents);
        this.myModuleComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myModuleComponents, descriptor2.myModuleComponents);
    }

    @Override
    public boolean isBundled() {
        String path2;
        if ("org.jetbrains.kotlin.com.intellij".equals(this.myId.getIdString())) {
            return true;
        }
        try {
            path2 = this.getPath().getCanonicalPath();
        }
        catch (IOException e) {
            path2 = this.getPath().getAbsolutePath();
        }
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isInternal()) {
            if (path2.startsWith(PathManager.getHomePath() + File.separator + "out" + File.separator + "classes")) {
                return true;
            }
            if (app.isUnitTestMode() && !path2.startsWith(PathManager.getPluginsPath() + File.separatorChar)) {
                return true;
            }
        }
        return path2.startsWith(PathManager.getPreInstalledPluginsPath());
    }

    @Nullable
    public List<String> getModules() {
        return this.myModules;
    }
}

