/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.util.Preconditions;
import com.twosigma.beakerx.widget.Layout;
import com.twosigma.beakerx.widget.Style;
import com.twosigma.beakerx.widget.UpdateValueCallback;
import com.twosigma.beakerx.widget.Widget;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class DOMWidget
extends Widget {
    public static final String DATA = "data";
    public static final String SYNC_DATA = "state";
    public static final String MODEL_MODULE_VALUE = "@jupyter-widgets/controls";
    public static final String VIEW_MODULE_VALUE = "@jupyter-widgets/controls";
    private Layout layout;
    protected Style style;
    private UpdateValueCallback updateValueCallback = () -> {};

    public DOMWidget() {
        this.layout = new Layout();
    }

    @Override
    protected void addValueChangeMsgCallback() {
        this.getComm().addMsgCallbackList(new ValueChangeMsgCallbackHandler(){

            @Override
            public void updateValue(Object value, Message message) {
                DOMWidget.this.doUpdateValueWithCallback(value);
            }
        });
    }

    public void register(UpdateValueCallback updateValueCallback) {
        this.updateValueCallback = Preconditions.checkNotNull(updateValueCallback);
    }

    public abstract void updateValue(Object var1);

    public void doUpdateValueWithCallback(Object value) {
        this.updateValue(value);
        this.updateValueCallback.execute();
    }

    @Override
    public String getModelModuleValue() {
        return "@jupyter-widgets/controls";
    }

    @Override
    public String getViewModuleValue() {
        return "@jupyter-widgets/controls";
    }

    @Override
    protected HashMap<String, Serializable> content(HashMap<String, Serializable> content) {
        content.put("layout", (Serializable)((Object)("IPY_MODEL_" + this.getLayout().getComm().getCommId())));
        if (this.style != null) {
            content.put("style", (Serializable)((Object)("IPY_MODEL_" + this.getStyle().getComm().getCommId())));
        }
        content.put("font_family", (Serializable)((Object)""));
        content.put("font_size", (Serializable)((Object)""));
        content.put("font_style", (Serializable)((Object)""));
        content.put("font_weight", (Serializable)((Object)""));
        content.put("background_color", null);
        content.put("color", null);
        return content;
    }

    public Layout getLayout() {
        if (this.layout == null) {
            this.layout = new Layout();
        }
        return this.layout;
    }

    public Style getStyle() {
        return this.style;
    }

    public abstract class ValueChangeMsgCallbackHandler
    implements Handler<Message> {
        public Optional<Object> getSyncDataValue(Message msg) {
            Map data;
            Optional<Object> ret = Optional.empty();
            if (msg != null && msg.getContent() != null && msg.getContent().containsKey(DOMWidget.DATA) && (data = (Map)((Object)msg.getContent().get(DOMWidget.DATA))).containsKey(DOMWidget.SYNC_DATA)) {
                Map sync_data = (Map)data.get(DOMWidget.SYNC_DATA);
                if (sync_data.containsKey("value")) {
                    ret = Optional.of(sync_data.get("value"));
                } else if (sync_data.containsKey("index")) {
                    ret = Optional.of(sync_data.get("index"));
                } else if (sync_data.containsKey("outputs")) {
                    ret = Optional.of(sync_data.get("outputs"));
                }
            }
            return ret;
        }

        @Override
        public void handle(Message message) {
            Optional<Object> value = this.getSyncDataValue(message);
            value.ifPresent(o -> this.updateValue(o, message));
        }

        public abstract void updateValue(Object var1, Message var2);
    }
}

