/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.table;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.table.TableDisplay;
import com.twosigma.beakerx.table.action.TableActionDetails;
import com.twosigma.beakerx.widget.CommActions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class TableDisplayActions {
    private TableDisplay tableDisplay;

    public TableDisplayActions(TableDisplay tableDisplay) {
        this.tableDisplay = tableDisplay;
    }

    private boolean isCorrectEvent(Message message, CommActions commActions) {
        LinkedHashMap data = (LinkedHashMap)message.getContent().get("data");
        LinkedHashMap content = (LinkedHashMap)data.get("content");
        if (null != content && !content.isEmpty()) {
            String event = content.getOrDefault("event", "");
            return commActions.getAction().equals(event);
        }
        return false;
    }

    void handleSetDetails(Message message) {
        if (this.isCorrectEvent(message, CommActions.ACTIONDETAILS)) {
            this.tableDisplay.handleCommEventSync(message, CommActions.ACTIONDETAILS, this::onActionDetails);
        }
    }

    private void onActionDetails(HashMap content, Message message) {
        TableActionDetails details = new TableActionDetails();
        if (content.containsKey("params")) {
            Object value;
            HashMap params = (HashMap)content.get("params");
            if (params.containsKey("actionType")) {
                value = CommActions.getByAction((String)params.get("actionType"));
                details.setActionType((CommActions)((Object)value));
            }
            if (params.containsKey("contextMenuItem")) {
                value = (String)params.get("contextMenuItem");
                details.setContextMenuItem((String)value);
            }
            if (params.containsKey("row")) {
                value = (Integer)params.get("row");
                details.setRow((Integer)value);
            }
            if (params.containsKey("col")) {
                value = (Integer)params.get("col");
                details.setCol((Integer)value);
            }
            if (params.containsKey("tag")) {
                value = (String)params.get("tag");
                details.setTag((String)value);
            }
        }
        this.tableDisplay.setDetails(details);
        if (CommActions.CONTEXT_MENU_CLICK.equals((Object)details.getActionType())) {
            if (this.tableDisplay.getContextMenuTags() != null && !this.tableDisplay.getContextMenuTags().isEmpty() && details.getContextMenuItem() != null && !details.getContextMenuItem().isEmpty()) {
                NamespaceClient.getBeaker().runByTag(this.tableDisplay.getContextMenuTags().get(details.getContextMenuItem()));
            }
        } else if (CommActions.DOUBLE_CLICK.equals((Object)details.getActionType()) && this.tableDisplay.getDoubleClickTag() != null && !this.tableDisplay.getDoubleClickTag().isEmpty()) {
            NamespaceClient.getBeaker().runByTag(this.tableDisplay.getDoubleClickTag());
        }
    }

    void handleDoubleClick(Message message) {
        if (this.isCorrectEvent(message, CommActions.DOUBLE_CLICK)) {
            this.tableDisplay.handleCommEventSync(message, CommActions.DOUBLE_CLICK, this::onDoubleClickAction);
        }
    }

    private void onDoubleClickAction(HashMap content, Message message) {
        CommActions actionType = CommActions.getByAction((String)content.get("event"));
        Object row = content.get("row");
        Object column = content.get("column");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(row);
        params.add(column);
        TableActionDetails details = new TableActionDetails();
        details.setActionType(actionType);
        details.setRow((Integer)row);
        details.setCol((Integer)column);
        this.tableDisplay.setDetails(details);
        this.tableDisplay.fireDoubleClick(params, message);
    }

    void handleOnContextMenu(Message message) {
        if (this.isCorrectEvent(message, CommActions.CONTEXT_MENU_CLICK)) {
            this.tableDisplay.handleCommEventSync(message, CommActions.CONTEXT_MENU_CLICK, this::onContextMenu);
        }
    }

    private void onContextMenu(HashMap content, Message message) {
        CommActions actionType = CommActions.getByAction((String)content.get("event"));
        String menuKey = (String)content.get("itemKey");
        Object row = content.get("row");
        Object column = content.get("column");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(row);
        params.add(column);
        TableActionDetails details = new TableActionDetails();
        details.setActionType(actionType);
        details.setRow((Integer)row);
        details.setCol((Integer)column);
        this.tableDisplay.setDetails(details);
        this.tableDisplay.fireContextMenuClick(menuKey, params, message);
    }
}

