/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeItOption;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeMeasureData;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.message.Message;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.text.StrTokenizer;

public abstract class TimeMagicCommand
implements MagicCommandFunctionality {
    protected KernelFunctionality kernel;

    public TimeMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    public MagicCommandOutput time(String codeToExecute, Message message, int executionCount, boolean showResult) {
        CompletableFuture<TimeMeasureData> compileTime = new CompletableFuture<TimeMeasureData>();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long currentThreadId = Thread.currentThread().getId();
        Long startWallTime = System.nanoTime();
        Long startCpuTotalTime = threadMXBean.getCurrentThreadCpuTime();
        Long startUserTime = threadMXBean.getCurrentThreadUserTime();
        SimpleEvaluationObject simpleEvaluationObject = PlainCode.createSimpleEvaluationObject(codeToExecute, this.kernel, message, executionCount);
        if (!showResult) {
            simpleEvaluationObject.noResult();
        }
        TryResult either = this.kernel.executeCode(codeToExecute, simpleEvaluationObject);
        Long endWallTime = System.nanoTime();
        Long endCpuTotalTime = threadMXBean.getThreadCpuTime(currentThreadId);
        Long endUserTime = threadMXBean.getThreadUserTime(currentThreadId);
        compileTime.complete(new TimeMeasureData(endCpuTotalTime - startCpuTotalTime, endUserTime - startUserTime, endWallTime - startWallTime));
        String messageInfo = "CPU times: user %s, sys: %s, total: %s \nWall Time: %s\n";
        try {
            TimeMeasureData timeMeasuredData = (TimeMeasureData)compileTime.get();
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, String.format(messageInfo, this.format(timeMeasuredData.getCpuUserTime()), this.format(timeMeasuredData.getCpuTotalTime() - timeMeasuredData.getCpuUserTime()), this.format(timeMeasuredData.getCpuTotalTime()), this.format(timeMeasuredData.getWallTime())), either, simpleEvaluationObject);
        }
        catch (InterruptedException | ExecutionException e) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem during measuring time for your statement.");
        }
    }

    private String format(Long nanoSeconds) {
        if (nanoSeconds < 1000L) {
            return nanoSeconds + " ns";
        }
        if (nanoSeconds >= 1000L && nanoSeconds < 1000000L) {
            return TimeUnit.NANOSECONDS.toMicros(nanoSeconds) + " \u00b5s";
        }
        if (nanoSeconds > 1000000L && nanoSeconds < 1000000000L) {
            return TimeUnit.NANOSECONDS.toMillis(nanoSeconds) + " ms";
        }
        return TimeUnit.NANOSECONDS.toSeconds(nanoSeconds) + " s";
    }

    protected MagicCommandOutput timeIt(TimeItOption timeItOption, String codeToExecute, Message message, int executionCount, boolean showResult) {
        int number;
        String output = "%s \u00b1 %s per loop (mean \u00b1 std. dev. of %d run, %d loop each)";
        if (timeItOption.getNumber() < 0) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Number of execution must be bigger then 0");
        }
        int n = number = timeItOption.getNumber() == 0 ? this.getBestNumber(codeToExecute, showResult) : timeItOption.getNumber().intValue();
        if (timeItOption.getRepeat() == 0) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Repeat value must be bigger then 0");
        }
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject(codeToExecute, this.kernel, message, executionCount);
        seo.noResult();
        TryResult either = this.kernel.executeCode(codeToExecute, seo);
        try {
            if (either.isError()) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Please correct your statement");
            }
            ArrayList allRuns = new ArrayList();
            ArrayList timings = new ArrayList();
            CompletableFuture isReady = new CompletableFuture();
            IntStream.range(0, timeItOption.getRepeat()).forEach(repeatIter -> IntStream.range(0, number).forEach(numberIter -> {
                SimpleEvaluationObject seo2 = PlainCode.createSimpleEvaluationObject(codeToExecute, this.kernel, message, executionCount);
                seo2.noResult();
                Long startOfEvaluationInNanoseconds = System.nanoTime();
                TryResult result = this.kernel.executeCode(codeToExecute, seo2);
                Long endOfEvaluationInNanoseconds = System.nanoTime();
                allRuns.add(endOfEvaluationInNanoseconds - startOfEvaluationInNanoseconds);
                if (repeatIter == timeItOption.getRepeat() - 1 && numberIter == number - 1) {
                    isReady.complete(true);
                }
            }));
            if (((Boolean)isReady.get()).booleanValue()) {
                allRuns.forEach(run -> timings.add(run / (long)number));
                long average = timings.stream().reduce((aLong, aLong2) -> aLong + aLong2).orElse(0L) / (long)timings.size();
                double stdev = Math.pow(timings.stream().map(currentValue -> Math.pow(currentValue - average, 2.0)).reduce((aDouble, aDouble2) -> aDouble + aDouble2).orElse(0.0) / (double)timings.size(), 0.5);
                output = timeItOption.getQuietMode() != false ? "" : String.format(output, this.format(average), this.format((long)stdev), timeItOption.getRepeat(), number);
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, output);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem with " + e.getMessage());
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem with timeIt operations");
    }

    protected TimeItOption buildTimeItOption(Code code) {
        TimeItOption timeItOption = new TimeItOption();
        try {
            StrTokenizer tokenizer = new StrTokenizer(code.asString());
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.createForTimeIt(), tokenizer.getTokenArray());
            if (cmd.hasOption('n')) {
                timeItOption.setNumber(Integer.valueOf(cmd.getOptionValue('n')));
            }
            if (cmd.hasOption('r')) {
                timeItOption.setRepeat(Integer.valueOf(cmd.getOptionValue('r')));
            }
            if (cmd.hasOption('q')) {
                timeItOption.setQuietMode(true);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected value must be a number " + e.getMessage().toLowerCase());
        }
        return timeItOption;
    }

    private Options createForTimeIt() {
        Options options = new Options();
        options.addOption("n", true, "Execute the given statement <N> times in a loop");
        options.addOption("r", true, "Repeat the loop iteration <R> times and take the best result. Default: 3");
        options.addOption("q", false, "Quiet, do not print result.");
        return options;
    }

    private int getBestNumber(String codeToExecute, boolean showResult) {
        for (int value = 0; value < 10; ++value) {
            Double numberOfExecution = Math.pow(10.0, value);
            CompletableFuture keepLooking = new CompletableFuture();
            Long startTime = System.nanoTime();
            IntStream.range(0, numberOfExecution.intValue()).forEach(indexOfExecution -> {
                SimpleEvaluationObject simpleEvaluationObject = PlainCode.createSimpleEvaluationObject(codeToExecute, this.kernel, new Message(), 0);
                if (!showResult) {
                    simpleEvaluationObject.noResult();
                }
                this.kernel.executeCode(codeToExecute, simpleEvaluationObject);
                if (numberOfExecution.intValue() - 1 == indexOfExecution) {
                    if ((double)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime) > 0.2) {
                        keepLooking.complete(false);
                    } else {
                        keepLooking.complete(true);
                    }
                }
            });
            try {
                if (((Boolean)keepLooking.get()).booleanValue()) {
                    continue;
                }
                return numberOfExecution.intValue();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException("Cannot create best number of execution.");
            }
        }
        throw new IllegalStateException("Cannot create best number of execution.");
    }
}

