/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.Repos;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MavenJarResolver;
import com.twosigma.beakerx.kernel.magic.command.PomFactory;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.functionality.MvnLoggerWidget;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;

public class ClasspathAddMvnMagicCommand
extends ClasspathMagicCommand {
    public static final String ADD = "add";
    public static final String MVN = "mvn";
    public static final String CLASSPATH_ADD_MVN = "%classpath add mvn";
    public static final String ADD_MVN_FORMAT_ERROR_MESSAGE = "Wrong command format, should be%classpath add mvn group name version [type] or %classpath add mvn group:name:version:[type]";
    private MavenJarResolver.ResolverParams commandParams;
    private PomFactory pomFactory;
    private Repos repos;

    public ClasspathAddMvnMagicCommand(MavenJarResolver.ResolverParams commandParams, KernelFunctionality kernel) {
        super(kernel);
        this.commandParams = commandParams;
        this.pomFactory = new PomFactory();
        this.repos = new Repos();
    }

    @Override
    public String getMagicCommandName() {
        return CLASSPATH_ADD_MVN;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 3 && commandParts[0].equals("%classpath") && commandParts[1].equals(ADD) && commandParts[2].equals(MVN);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath(command);
        if (!this.isGradleFormat(split) && !this.isMavenFormat(split)) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, ADD_MVN_FORMAT_ERROR_MESSAGE);
        }
        this.commandParams.setRepos(this.getRepos().get());
        MavenJarResolver classpathAddMvnCommand = new MavenJarResolver(this.commandParams, this.pomFactory);
        MvnLoggerWidget progress = new MvnLoggerWidget(param.getCode().getMessage());
        MavenJarResolver.AddMvnCommandResult result = this.retrieve(this.getDependency(split), classpathAddMvnCommand, progress);
        if (result.isJarRetrieved()) {
            return this.handleAddedJars(classpathAddMvnCommand.getPathToMavenRepo() + "/*");
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, result.getErrorMessage());
    }

    private MavenJarResolver.Dependency getDependency(String[] split) {
        if (this.isGradleFormat(split)) {
            String[] valuesFromGradlePattern = split[3].split(":");
            return this.getDepForGradle(valuesFromGradlePattern);
        }
        return this.getDepForMaven(split);
    }

    private boolean isMavenFormat(String[] split) {
        return split.length == 6 || split.length == 7;
    }

    private boolean isGradleFormat(String[] split) {
        if (split.length == 4) {
            String[] valuesFromGradlePattern = split[3].split(":");
            return valuesFromGradlePattern.length == 3 || valuesFromGradlePattern.length == 4;
        }
        return false;
    }

    private MavenJarResolver.Dependency getDepForMaven(String[] split) {
        if (split.length == 7) {
            return new MavenJarResolver.Dependency(split[3], split[4], split[5], split[6]);
        }
        return new MavenJarResolver.Dependency(split[3], split[4], split[5]);
    }

    private MavenJarResolver.Dependency getDepForGradle(String[] valuesFromGradlePattern) {
        if (valuesFromGradlePattern.length == 4) {
            return new MavenJarResolver.Dependency(valuesFromGradlePattern[0], valuesFromGradlePattern[1], valuesFromGradlePattern[2], valuesFromGradlePattern[3]);
        }
        return new MavenJarResolver.Dependency(valuesFromGradlePattern[0], valuesFromGradlePattern[1], valuesFromGradlePattern[2]);
    }

    private MavenJarResolver.AddMvnCommandResult retrieve(MavenJarResolver.Dependency dependency, MavenJarResolver classpathAddMvnCommand, MvnLoggerWidget progress) {
        return classpathAddMvnCommand.retrieve(dependency, progress);
    }

    public MavenJarResolver.ResolverParams getCommandParams() {
        return this.commandParams;
    }

    public Repos getRepos() {
        return this.repos;
    }

    public String addRepo(String name, String url) {
        return this.repos.add(name, url);
    }

    public void resetRepo() {
        this.repos = new Repos();
    }
}

