/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandTypesFactory;
import com.twosigma.beakerx.kernel.magic.command.MavenJarResolver;
import com.twosigma.beakerx.kernel.magic.command.PomFactory;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddMvnMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.functionality.MvnLoggerWidget;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassPathAddMvnCellMagicCommand
extends ClasspathMagicCommand {
    public static final String ADD = "add";
    public static final String MVN = "mvn";
    public static final String CLASSPATH_ADD_MVN_CELL = "%%classpath add mvn";
    public static final String MVN_CELL_FORMAT_ERROR_MESSAGE = "Wrong command format, should be %%classpath add mvn\n group name version or group:name:version\n group name version or group:name:version";
    private static final String SPLIT_LINE_REGEX = "\\r?\\n";
    private MavenJarResolver.ResolverParams commandParams;
    private PomFactory pomFactory;

    public ClassPathAddMvnCellMagicCommand(MavenJarResolver.ResolverParams commandParams, KernelFunctionality kernel) {
        super(kernel);
        this.commandParams = commandParams;
        this.pomFactory = new PomFactory();
    }

    @Override
    public String getMagicCommandName() {
        return CLASSPATH_ADD_MVN_CELL;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length >= 3 && commandParts[0].equals("%%classpath") && commandParts[1].equals(ADD) && commandParts[2].equals(MVN);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        String commandCodeBlock = param.getCommandCodeBlock();
        if (commandCodeBlock != null) {
            command = command + "\n" + commandCodeBlock;
        }
        String[] commandLines = command.split(SPLIT_LINE_REGEX);
        this.unifyMvnLineFormat(commandLines);
        if (!this.validateCommandLines(commandLines)) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, MVN_CELL_FORMAT_ERROR_MESSAGE);
        }
        ClasspathAddMvnMagicCommand mvnMagicCommand = MagicCommandTypesFactory.getClasspathAddMvnMagicCommand(this.kernel);
        this.commandParams.setRepos(mvnMagicCommand.getRepos().get());
        List<MavenJarResolver.Dependency> dependencies = this.getDepsFromCommand(Arrays.copyOfRange(commandLines, 1, commandLines.length));
        MavenJarResolver mavenJarResolver = new MavenJarResolver(this.commandParams, this.pomFactory);
        MvnLoggerWidget mvnLoggerWidget = new MvnLoggerWidget(param.getCode().getMessage());
        MavenJarResolver.AddMvnCommandResult result = mavenJarResolver.retrieve(dependencies, mvnLoggerWidget);
        if (result.isJarRetrieved()) {
            return this.handleAddedJars(mavenJarResolver.getPathToMavenRepo() + "/*");
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, result.getErrorMessage());
    }

    private List<MavenJarResolver.Dependency> getDepsFromCommand(String[] lines) {
        ArrayList<MavenJarResolver.Dependency> dependencies = new ArrayList<MavenJarResolver.Dependency>();
        for (String line : lines) {
            String[] dependencyData = MagicCommandUtils.splitPath(line);
            dependencies.add(this.getDep(dependencyData));
        }
        return dependencies;
    }

    private MavenJarResolver.Dependency getDep(String[] split) {
        if (split.length == 4) {
            return new MavenJarResolver.Dependency(split[0], split[1], split[2], split[3]);
        }
        return new MavenJarResolver.Dependency(split[0], split[1], split[2]);
    }

    private boolean validateCommandLines(String[] commandLines) {
        boolean isValid = false;
        for (int i = 1; i < commandLines.length; ++i) {
            String[] strings = MagicCommandUtils.splitPath(commandLines[i]);
            if (strings.length != 3 && strings.length != 4) {
                isValid = false;
                break;
            }
            isValid = true;
        }
        return isValid;
    }

    private void unifyMvnLineFormat(String[] mvnLines) {
        for (int i = 0; i < mvnLines.length; ++i) {
            mvnLines[i] = mvnLines[i].replace(":", " ");
        }
    }
}

