/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.comm.TargetNamesEnum;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.CommActions;
import com.twosigma.beakerx.widget.CommFunctionality;
import com.twosigma.beakerx.widget.CompiledCodeRunner;
import com.twosigma.beakerx.widget.DisplayableWidget;
import java.io.Serializable;
import java.util.HashMap;

public abstract class Widget
implements CommFunctionality,
DisplayableWidget {
    public static final String APPLICATION_VND_JUPYTER_WIDGET_VIEW_JSON = "application/vnd.jupyter.widget-view+json";
    public static final String MODEL_ID = "model_id";
    public static final String MODEL_MODULE = "_model_module";
    public static final String MODEL_NAME = "_model_name";
    public static final String VIEW_MODULE = "_view_module";
    public static final String VIEW_NAME = "_view_name";
    public static final String VIEW_MODULE_VERSION = "_view_module_version";
    public static final String MODEL_MODULE_VERSION = "_model_module_version";
    public static final String MODEL_MODULE_VALUE = "@jupyter-widgets/controls";
    public static final String VIEW_MODULE_VALUE = "@jupyter-widgets/controls";
    public static final String MODEL_MODULE_VERSION_VALUE = "*";
    public static final String VIEW_MODULE_VERSION_VALUE = "*";
    public static final String VALUE = "value";
    public static final String DISABLED = "disabled";
    public static final String VISIBLE = "visible";
    public static final String DESCRIPTION = "description";
    public static final String MSG_THROTTLE = "msg_throttle";
    public static final String METHOD = "method";
    public static final String DISPLAY = "display_data";
    public static final String INDEX = "index";
    private Comm comm = new Comm(TargetNamesEnum.JUPYTER_WIDGET);

    protected void openComm() {
        this.openComm(Comm.Buffer.EMPTY);
    }

    protected void openComm(Comm.Buffer buffer) {
        this.comm.setData(this.createContent());
        this.addValueChangeMsgCallback();
        this.comm.open(buffer);
    }

    protected void openComm(Message parentMessage) {
        this.comm.setData(this.createContent());
        this.addValueChangeMsgCallback();
        this.comm.open(parentMessage);
    }

    @Override
    public void close() {
        if (this.comm != null) {
            this.comm.close();
        }
    }

    @Override
    public void display() {
        this.beforeDisplay();
        this.sendDisplay();
    }

    protected void beforeDisplay() {
    }

    private void sendDisplay() {
        HashMap<String, Object> content = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("version_major", 2);
        data.put("version_minor", 0);
        data.put(MODEL_ID, this.getComm().getCommId());
        content.put(METHOD, DISPLAY);
        content.put(APPLICATION_VND_JUPYTER_WIDGET_VIEW_JSON, data);
        this.getComm().send(JupyterMessages.DISPLAY_DATA, new Comm.Data(content));
    }

    private HashMap<String, Serializable> createContent() {
        String vnv;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put(MODEL_MODULE, (Serializable)((Object)this.getModelModuleValue()));
        result.put(VIEW_MODULE, (Serializable)((Object)this.getViewModuleValue()));
        result.put(VIEW_MODULE_VERSION, (Serializable)((Object)this.getViewModuleVersion()));
        result.put(MODEL_MODULE_VERSION, (Serializable)((Object)this.getModelModuleVersion()));
        String mn = this.getModelNameValue();
        if (mn != null && !mn.isEmpty()) {
            result.put(MODEL_NAME, (Serializable)((Object)mn));
        }
        if ((vnv = this.getViewNameValue()) != null && !vnv.isEmpty()) {
            result.put(VIEW_NAME, (Serializable)((Object)vnv));
        }
        result = this.content(result);
        return result;
    }

    public abstract String getModelNameValue();

    public abstract String getViewNameValue();

    public String getModelModuleValue() {
        return "@jupyter-widgets/controls";
    }

    public String getViewModuleValue() {
        return "@jupyter-widgets/controls";
    }

    public String getModelModuleVersion() {
        return "*";
    }

    public String getViewModuleVersion() {
        return "*";
    }

    protected abstract void addValueChangeMsgCallback();

    protected abstract HashMap<String, Serializable> content(HashMap<String, Serializable> var1);

    @Override
    public Comm getComm() {
        return this.comm;
    }

    public void sendUpdate(String propertyName, Object value) {
        this.comm.sendUpdate(propertyName, value);
    }

    public void sendUpdate(Comm.Buffer buffer) {
        this.comm.sendUpdate(buffer);
    }

    public void handleCommEventSync(Message message, CommActions action, ActionPerformed handlerAction) {
        KernelHandlerWrapper.wrapBusyIdle(KernelManager.get(), message, () -> CompiledCodeRunner.runCommEvent(message, action, handlerAction));
    }

    public void activateWidgetInContainer() {
    }

    public static interface ActionPerformed {
        public void executeAction(HashMap var1, Message var2);
    }
}

