/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.widget.Output;

public class OutputManager {
    private static Output output;
    private static Output stderr;
    private static Output stdout;

    public static Output setOutput(Output out) {
        output = out;
        return output;
    }

    public static Output setStandardError(Output out) {
        stderr = out;
        return stderr;
    }

    public static Output setStandardOutput(Output out) {
        stdout = out;
        return stdout;
    }

    public static void clearStderr() {
        if (stderr != null) {
            stderr.clearOutput();
        }
    }

    public static void clearStdout() {
        if (stdout != null) {
            stdout.clearOutput();
        }
    }

    public static void clearOutput() {
        if (output != null) {
            output.clearOutput();
        }
    }

    public static void clear() {
        OutputManager.clearOutput();
        OutputManager.clearStdout();
        OutputManager.clearStderr();
    }

    public static boolean sendStdout(String s) {
        if (output != null || stdout != null) {
            if (output != null) {
                output.sendStdout(s);
            }
            if (stdout != null) {
                stdout.sendStdout(s);
            }
            return true;
        }
        return false;
    }

    public static boolean sendStderr(String s) {
        if (output != null || stderr != null) {
            if (output != null) {
                output.sendStderr(s);
            }
            if (stderr != null) {
                stderr.sendStderr(s);
            }
            return true;
        }
        return false;
    }
}

