/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx;

import com.twosigma.beakerx.BeakerImplementationInfo;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KernelInfoHandler
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(KernelInfoHandler.class);
    public static final String PROTOCOL_VERSION = "protocol_version";
    public static final String PROTOCOL_VERSION_NUMBER = "5.1";

    public KernelInfoHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle(this.kernel, message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        logger.debug("Processing kernel info request");
        Message reply = new Message();
        reply.setContent(this.content());
        reply.setHeader(new Header(JupyterMessages.KERNEL_INFO_REPLY, message.getHeader().getSession()));
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        this.send(reply);
    }

    private HashMap<String, Serializable> languageInfo() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        return this.doLanguageInfo(map);
    }

    private HashMap<String, Serializable> content() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("implementation_version", (Serializable)((Object)BeakerImplementationInfo.IMPLEMENTATION_VERSION));
        map.put(PROTOCOL_VERSION, (Serializable)((Object)PROTOCOL_VERSION_NUMBER));
        map.put("language_info", this.languageInfo());
        map.put("help_links", this.getHelpLinks());
        map.put("beakerx", Boolean.valueOf(true));
        map.put("status", (Serializable)((Object)"ok"));
        return this.doContent(map);
    }

    private ArrayList<HelpLink> getHelpLinks() {
        HelpLink beakerXHome = new HelpLink("BeakerX Home", "http://BeakerX.com");
        HelpLink fileAnIssue = new HelpLink("File an Issue", "https://github.com/twosigma/beakerx/issues/new");
        HelpLink twoSigmaOpenSource = new HelpLink("Two Sigma Open Source", "http://opensource.twosigma.com/");
        HelpLink javadoc = new HelpLink("BeakerX JavaDoc", "javadoc/index.html");
        return new ArrayList<HelpLink>(Arrays.asList(beakerXHome, fileAnIssue, twoSigmaOpenSource, javadoc));
    }

    protected abstract HashMap<String, Serializable> doLanguageInfo(HashMap<String, Serializable> var1);

    protected abstract HashMap<String, Serializable> doContent(HashMap<String, Serializable> var1);

    private class HelpLink
    implements Serializable {
        protected String text;
        protected String url;

        HelpLink(String text, String url) {
            this.text = text;
            this.url = url;
        }

        public String getText() {
            return this.text;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

