/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.javash.JavaBeakerXUrlClassLoader;
import com.twosigma.beakerx.javash.autocomplete.JavaAutocomplete;
import com.twosigma.beakerx.javash.autocomplete.JavaClasspathScanner;
import com.twosigma.beakerx.javash.evaluator.JavaWorkerThread;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import com.twosigma.beakerx.kernel.PathToJar;
import java.io.File;
import java.util.concurrent.Executors;

public class JavaEvaluator
extends BaseEvaluator {
    public static final String WRAPPER_CLASS_NAME = "BeakerWrapperClass1261714175";
    private final String packageId = "com.twosigma.beaker.javash.bkr" + this.shellId.split("-")[0];
    private JavaClasspathScanner cps = new JavaClasspathScanner();
    private JavaAutocomplete jac = this.createJavaAutocomplete(this.cps);
    private JavaBeakerXUrlClassLoader loader = this.newClassLoader();

    public JavaEvaluator(String id, String sId, EvaluatorParameters evaluatorParameters) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("javash"), (TempFolderFactory)new TempFolderFactoryImpl(), evaluatorParameters);
    }

    public JavaEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters);
    }

    public ClassLoader getClassLoaderForImport() {
        return this.getJavaClassLoader().getJavaURLClassLoader();
    }

    protected void doResetEnvironment() {
        String cpp = this.createClasspath(this.classPath, this.outDir);
        this.cps = new JavaClasspathScanner(cpp);
        this.jac = this.createAutocomplete(this.imports, this.cps);
        this.loader = this.newClassLoader();
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    protected void addJarToClassLoader(PathToJar pathToJar) {
        this.loader.addJar(pathToJar);
    }

    protected void addImportToClassLoader(ImportPath anImport) {
    }

    public void exit() {
        super.exit();
        this.cancelExecution();
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public TryResult evaluate(SimpleEvaluationObject seo, String code) {
        return this.evaluate(seo, new JavaWorkerThread(this, new JobDescriptor(code, seo)));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.jac.doAutocomplete(code, caretPosition, this.loader, this.imports);
    }

    private JavaAutocomplete createJavaAutocomplete(JavaClasspathScanner c) {
        return new JavaAutocomplete(c);
    }

    private JavaAutocomplete createAutocomplete(Imports imports, JavaClasspathScanner cps) {
        JavaAutocomplete jac = this.createJavaAutocomplete(cps);
        for (ImportPath st : imports.getImportPaths()) {
            jac.addImport(st.asString());
        }
        return jac;
    }

    private String createClasspath(Classpath classPath, String outDir) {
        String cpp = "";
        for (String pt : classPath.getPathsAsStrings()) {
            cpp = cpp + pt;
            cpp = cpp + File.pathSeparator;
        }
        cpp = cpp + File.pathSeparator;
        cpp = cpp + System.getProperty("java.class.path");
        return cpp;
    }

    public String getPackageId() {
        return this.packageId;
    }

    private JavaBeakerXUrlClassLoader newClassLoader() {
        JavaBeakerXUrlClassLoader loader = new JavaBeakerXUrlClassLoader(ClassLoader.getSystemClassLoader(), new PathToJar(this.outDir));
        loader.addInitPathToJars(this.getClasspath().getPaths());
        return loader;
    }

    public JavaBeakerXUrlClassLoader getJavaClassLoader() {
        return this.loader;
    }
}

