/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.LinkedMultiMap;
import org.jetbrains.kotlin.com.intellij.util.containers.SmartHashSet;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;

public class MultiMap<K, V>
implements Serializable {
    public static final MultiMap EMPTY = new EmptyMap();
    protected final Map<K, Collection<V>> myMap = this.createMap();

    @NotNull
    protected Map<K, Collection<V>> createMap() {
        HashMap hashMap = new HashMap();
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "createMap"));
        }
        return hashMap;
    }

    @NotNull
    protected Collection<V> createCollection() {
        SmartList smartList = new SmartList();
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "createCollection"));
        }
        return smartList;
    }

    @NotNull
    protected Collection<V> createEmptyCollection() {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "createEmptyCollection"));
        }
        return list2;
    }

    public <Kk extends K, Vv extends V> void putAllValues(@NotNull MultiMap<Kk, Vv> from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "putAllValues"));
        }
        for (Map.Entry<Kk, Collection<Vv>> entry : from.entrySet()) {
            this.putValues(entry.getKey(), entry.getValue());
        }
    }

    public void putValues(K key, @NotNull Collection<? extends V> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "putValues"));
        }
        Collection<V> list2 = this.myMap.get(key);
        if (list2 == null) {
            list2 = this.createCollection();
            this.myMap.put(key, list2);
        }
        list2.addAll(values);
    }

    public void putValue(@Nullable K key, V value) {
        Collection<V> list2 = this.myMap.get(key);
        if (list2 == null) {
            list2 = this.createCollection();
            this.myMap.put(key, list2);
        }
        list2.add(value);
    }

    @NotNull
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        Set<Map.Entry<K, Collection<V>>> set = this.myMap.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "entrySet"));
        }
        return set;
    }

    public boolean isEmpty() {
        if (this.myMap.isEmpty()) {
            return true;
        }
        for (Collection<V> valueList : this.myMap.values()) {
            if (valueList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    @NotNull
    public Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        Collection<V> collection2 = collection == null ? this.createEmptyCollection() : collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "get"));
        }
        return collection2;
    }

    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "keySet"));
        }
        return set;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create() {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "create"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinked() {
        LinkedMultiMap linkedMultiMap = new LinkedMultiMap();
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "createLinked"));
        }
        return linkedMultiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinkedSet() {
        LinkedMultiMap linkedMultiMap = new LinkedMultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap$3", "createCollection"));
                }
                return linkedHashSet;
            }
        };
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "createLinkedSet"));
        }
        return linkedMultiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSmart() {
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                THashMap tHashMap = new THashMap();
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap$5", "createMap"));
                }
                return tHashMap;
            }
        };
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "createSmart"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet() {
        MultiMap<K, V> multiMap = MultiMap.createSet(TObjectHashingStrategy.CANONICAL);
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "createSet"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet(final TObjectHashingStrategy strategy) {
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                SmartHashSet smartHashSet = new SmartHashSet();
                if (smartHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap$7", "createCollection"));
                }
                return smartHashSet;
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap$7", "createEmptyCollection"));
                }
                return set;
            }

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                THashMap tHashMap = new THashMap(strategy);
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap$7", "createMap"));
                }
                return tHashMap;
            }
        };
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap", "createSet"));
        }
        return multiMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiMap)) {
            return false;
        }
        return this.myMap.equals(((MultiMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return this.myMap.toString();
    }

    private static class EmptyMap
    extends MultiMap {
        private EmptyMap() {
        }

        @NotNull
        protected Map createMap() {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/MultiMap$EmptyMap", "createMap"));
            }
            return map2;
        }
    }
}

