/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.inspect;

import com.twosigma.beakerx.inspect.ClassInspect;
import com.twosigma.beakerx.inspect.CodeParsingTool;
import com.twosigma.beakerx.inspect.InspectResult;
import com.twosigma.beakerx.inspect.MethodInspect;
import com.twosigma.beakerx.inspect.SerializeInspect;
import com.twosigma.beakerx.kernel.Imports;
import com.twosigma.beakerx.widget.BeakerxWidget;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class Inspect {
    private static final String COLOR_RED = "\u001b[31m";
    private static final String COLOR_RESET = "\u001b[0m";
    private static String inspectDataPath = "beakerx_inspect.json";

    public InspectResult doInspect(String code, int caretPosition, URLClassLoader classLoader, Imports imports) {
        InspectResult inspectResult = new InspectResult();
        if (code.length() >= caretPosition) {
            String methodName = CodeParsingTool.getSelectedMethodName(code, caretPosition);
            String className = CodeParsingTool.getClassName(code, caretPosition, methodName);
            try (FileInputStream inputStream = new FileInputStream(this.getInspectFile());){
                String inspectData = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                inspectResult = this.getInspectResult(caretPosition, methodName, className, inspectData);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return inspectResult;
    }

    private File getInspectFile() {
        Path workingDirectory = null;
        try {
            workingDirectory = Paths.get(BeakerxWidget.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath(), new String[0]).getParent().getParent();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return new File(workingDirectory.toFile(), inspectDataPath);
    }

    private InspectResult getInspectResult(int caretPosition, String methodName, String className, String everything) {
        HashMap<String, ClassInspect> stringClassInspectHashMap = new SerializeInspect().fromJson(everything);
        InspectResult inspectResult = new InspectResult();
        ClassInspect classInspect = null;
        if (stringClassInspectHashMap.containsKey(className)) {
            classInspect = stringClassInspectHashMap.get(className);
        } else {
            for (ClassInspect cls : stringClassInspectHashMap.values()) {
                if (!cls.getClassName().equals(className)) continue;
                classInspect = cls;
                break;
            }
        }
        if (methodName == null && classInspect != null) {
            List<MethodInspect> constructors = classInspect.getConstructors();
            String classInfo = this.parseClassInfo(classInspect) + "\n\n" + this.parseMethodsInfo(constructors, "");
            inspectResult = new InspectResult(classInfo, caretPosition);
        } else {
            List<MethodInspect> methodInspectsList;
            List<MethodInspect> list = methodInspectsList = classInspect == null ? null : classInspect.getMethods();
            if (methodInspectsList == null) {
                return new InspectResult();
            }
            List<MethodInspect> methods = methodInspectsList.stream().filter(m -> m.getMethodName().equals(methodName)).collect(Collectors.toList());
            if (!methods.isEmpty()) {
                return new InspectResult(this.parseMethodsInfo(methods, className), caretPosition);
            }
        }
        return inspectResult;
    }

    private String parseClassInfo(ClassInspect classInspect) {
        return "\u001b[31mClass: \u001b[0m" + classInspect.fullName + "\n" + COLOR_RED + "JavaDoc: " + (classInspect.getJavadoc().equals("") ? "<no JavaDoc>" : COLOR_RESET + classInspect.getJavadoc());
    }

    public static void setInspectFileName(String inspectDataPath) {
        Inspect.inspectDataPath = inspectDataPath;
    }

    public String parseMethodsInfo(List<MethodInspect> methods, String className) {
        if (methods == null) {
            return "";
        }
        String parsedMethods = methods.stream().map(m -> "\u001b[31mSignature: \u001b[0m" + className + (className.equals("") ? "" : ".") + m.getMethodName() + "(" + m.getSignature() + ")\n" + COLOR_RED + "JavaDoc: " + (m.getJavadoc().equals("") ? "<no JavaDoc>" : COLOR_RESET + m.getJavadoc())).collect(Collectors.joining("\n\n"));
        return parsedMethods;
    }
}

