/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

public abstract class DelegatingResolvedCall<D extends CallableDescriptor>
implements ResolvedCall<D> {
    private final ResolvedCall<? extends D> resolvedCall;

    public DelegatingResolvedCall(@NotNull ResolvedCall<? extends D> resolvedCall2) {
        this.resolvedCall = resolvedCall2;
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        return this.resolvedCall.getStatus();
    }

    @Override
    @NotNull
    public Call getCall() {
        return this.resolvedCall.getCall();
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        return this.resolvedCall.getCandidateDescriptor();
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        return this.resolvedCall.getResultingDescriptor();
    }

    @Override
    @Nullable
    public ReceiverValue getExtensionReceiver() {
        return this.resolvedCall.getExtensionReceiver();
    }

    @Override
    @Nullable
    public ReceiverValue getDispatchReceiver() {
        return this.resolvedCall.getDispatchReceiver();
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        return this.resolvedCall.getExplicitReceiverKind();
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        return this.resolvedCall.getValueArguments();
    }

    @Override
    @NotNull
    public ArgumentMapping getArgumentMapping(@NotNull ValueArgument valueArgument) {
        return this.resolvedCall.getArgumentMapping(valueArgument);
    }

    @Override
    @Nullable
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        return this.resolvedCall.getValueArgumentsByIndex();
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, KotlinType> getTypeArguments() {
        return this.resolvedCall.getTypeArguments();
    }

    @Override
    @NotNull
    public DataFlowInfoForArguments getDataFlowInfoForArguments() {
        return this.resolvedCall.getDataFlowInfoForArguments();
    }

    @Override
    @Nullable
    public KotlinType getSmartCastDispatchReceiverType() {
        return this.resolvedCall.getSmartCastDispatchReceiverType();
    }
}

