/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.google.common.base.Preconditions;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;

class KotlinCodeRunner
implements Callable<TryResult> {
    private final SimpleEvaluationObject theOutput;
    private final ClassLoader loader;
    private final ReplInterpreter repl;
    private final String codeToBeExecuted;

    public KotlinCodeRunner(SimpleEvaluationObject out, ClassLoader ld, ReplInterpreter repl, String codeToBeExecuted) {
        this.theOutput = (SimpleEvaluationObject)Preconditions.checkNotNull((Object)out);
        this.loader = (ClassLoader)Preconditions.checkNotNull((Object)ld);
        this.repl = (ReplInterpreter)Preconditions.checkNotNull((Object)repl);
        this.codeToBeExecuted = codeToBeExecuted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TryResult call() throws Exception {
        TryResult.CellError either;
        ClassLoader oldld = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
        try {
            this.theOutput.setOutputHandler();
            InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
            ReplEvalResult eval = this.repl.eval(this.codeToBeExecuted);
            either = this.interpretResult(eval);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof InterruptedException || e instanceof ThreadDeath) {
                either = TryResult.createError((String)BaseEvaluator.INTERUPTED_MSG);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                either = TryResult.createError((String)sw.toString());
            }
        }
        finally {
            this.theOutput.clrOutputHandler();
            Thread.currentThread().setContextClassLoader(oldld);
        }
        return either;
    }

    private TryResult interpretResult(Object o) {
        TryResult.CellResult either;
        if (o == null) {
            either = TryResult.createResult(null);
        } else if (o instanceof ReplEvalResult.UnitResult) {
            either = TryResult.createResult(null);
        } else if (o instanceof ReplEvalResult.ValueResult) {
            Object value = ((ReplEvalResult.ValueResult)o).getValue();
            either = TryResult.createResult((Object)value);
        } else if (o instanceof ReplEvalResult.Error) {
            String message = ((ReplEvalResult.Error)o).getMessage();
            either = TryResult.createError((String)message);
        } else {
            either = TryResult.createError((String)o.toString());
        }
        return either;
    }
}

