/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import com.google.common.base.Joiner;
import com.twosigma.beakerx.groovy.evaluator.GroovyNotFoundException;
import com.twosigma.beakerx.jvm.classloader.BeakerxUrlClassLoader;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyClassLoaderFactory {
    public static String GROOVY_JAR_PATH = "GROOVY_JAR_PATH";
    private static final String STATIC_WORD_WITH_SPACE = "static ";
    private static final String DOT_STAR_POSTFIX = ".*";

    public static GroovyClassLoader newEvaluator(Imports imports, Classpath classpath, String outDir, ImportCustomizer icz, ClassLoader parent) {
        try {
            Class.forName("org.codehaus.groovy.control.customizers.ImportCustomizer");
        }
        catch (ClassNotFoundException e1) {
            String gjp = System.getenv(GROOVY_JAR_PATH);
            String errorMsg = null;
            errorMsg = gjp != null && !gjp.isEmpty() ? "Groovy libary not found, GROOVY_JAR_PATH = " + gjp : "Default groovy libary not found. No GROOVY_JAR_PATH variable set.";
            throw new GroovyNotFoundException(errorMsg);
        }
        icz = GroovyClassLoaderFactory.addImportsCustomizer(icz, imports);
        CompilerConfiguration config = new CompilerConfiguration().addCompilationCustomizers(new CompilationCustomizer[]{icz});
        String acloader_cp = Joiner.on((char)File.pathSeparatorChar).join((Iterable)classpath.getPathsAsStrings());
        config.setClasspath(acloader_cp);
        return new GroovyClassLoader(parent, config);
    }

    private static ImportCustomizer addImportsCustomizer(ImportCustomizer icz, Imports imports) {
        if (!imports.isEmpty()) {
            for (ImportPath importLine : imports.getImportPaths()) {
                GroovyClassLoaderFactory.addImportPathToImportCustomizer(icz, importLine);
            }
        }
        return icz;
    }

    public static void addImportPathToImportCustomizer(ImportCustomizer icz, ImportPath importLine) {
        if (importLine.asString().startsWith(STATIC_WORD_WITH_SPACE)) {
            String pureImport = importLine.asString().replace(STATIC_WORD_WITH_SPACE, "").replace(DOT_STAR_POSTFIX, "");
            if (importLine.asString().endsWith(DOT_STAR_POSTFIX)) {
                icz.addStaticStars(new String[]{pureImport});
            } else {
                int index = pureImport.lastIndexOf(46);
                if (index == -1) {
                    return;
                }
                icz.addStaticImport(pureImport.substring(0, index), pureImport.substring(index + 1));
            }
        } else if (importLine.asString().endsWith(DOT_STAR_POSTFIX)) {
            icz.addStarImports(new String[]{importLine.asString().replace(DOT_STAR_POSTFIX, "")});
        } else {
            icz.addImports(new String[]{importLine.asString()});
        }
    }

    public static BeakerxUrlClassLoader newParentClassLoader(Classpath classpath) {
        BeakerxUrlClassLoader loader = new BeakerxUrlClassLoader(ClassLoader.getSystemClassLoader());
        loader.addPathToJars(classpath.getPaths());
        return loader;
    }
}

