/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteCandidate;
import com.twosigma.beakerx.autocomplete.AutocompleteRegistry;
import com.twosigma.beakerx.autocomplete.ClassUtils;
import com.twosigma.beakerx.groovy.autocomplete.AutocompleteGroovyResult;
import com.twosigma.beakerx.groovy.autocomplete.GroovyAbstractListener;
import com.twosigma.beakerx.groovy.autocomplete.GroovyParser;
import org.antlr.v4.runtime.ParserRuleContext;

public class GroovyNodeCompletion
extends GroovyAbstractListener {
    private AutocompleteRegistry registry;
    private int cursor;
    private String text;
    private ClassUtils classUtils;

    public GroovyNodeCompletion(String t, int c, AutocompleteRegistry r, ClassUtils cu) {
        this.cursor = c;
        this.text = t;
        this.registry = r;
        this.classUtils = cu;
    }

    @Override
    public void exitClassNameExpression(GroovyParser.ClassNameExpressionContext ctx) {
        if (ctx.getStart().getStartIndex() < this.cursor && ctx.getStop().getStopIndex() + 1 >= this.cursor) {
            if (ctx.getText().contains(".")) {
                String string = ctx.getText();
                this.classUtils.getClass();
                this.addQuery(this.classUtils.expandExpression(string, this.registry, 0), AutocompleteGroovyResult.getStartIndex(ctx));
                AutocompleteCandidate c = new AutocompleteCandidate(9, ctx.getText().substring(ctx.getText().lastIndexOf(".") + 1));
                this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx));
                this.completeClassFromPath(ctx);
            } else {
                AutocompleteCandidate c = new AutocompleteCandidate(3, ctx.getText());
                this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx));
                c = new AutocompleteCandidate(6, ctx.getText());
                this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx));
            }
        }
    }

    private void completeClassFromPath(GroovyParser.ClassNameExpressionContext ctx) {
        String text = ctx.getText();
        text = text.substring(text.lastIndexOf(".") + 1, text.length());
        AutocompleteCandidate cName = new AutocompleteCandidate(5, text);
        this.addQuery(cName, AutocompleteGroovyResult.getStartIndex(ctx));
    }

    @Override
    public void exitPathExpression(GroovyParser.PathExpressionContext ctx) {
        if (ctx.getStart().getStartIndex() < this.cursor && ctx.getStop().getStopIndex() + 1 >= this.cursor) {
            AutocompleteCandidate c;
            if (ctx.getParent().getChild(0).equals((Object)ctx) && ctx.getParent().getParent() != null && ctx.getParent().getParent() instanceof GroovyParser.StatementContext && ctx.getParent().getParent().getChild(0).equals(ctx.getParent())) {
                c = new AutocompleteCandidate(8, ctx.getText());
                this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx));
            }
            if (ctx.getText().contains(".")) {
                String string = ctx.getText();
                this.classUtils.getClass();
                this.addQuery(this.classUtils.expandExpression(string, this.registry, 1), AutocompleteGroovyResult.getStartIndex(ctx));
                c = new AutocompleteCandidate(9, ctx.getText().substring(ctx.getText().lastIndexOf(".") + 1));
                this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx));
                String string2 = ctx.getText();
                this.classUtils.getClass();
                this.addQuery(this.classUtils.expandExpression(string2, this.registry, 2), AutocompleteGroovyResult.getStartIndex(ctx));
            } else {
                c = new AutocompleteCandidate(3, ctx.getText());
                this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx));
                c = new AutocompleteCandidate(6, ctx.getText());
                this.addQuery(c, AutocompleteGroovyResult.getStartIndex(ctx));
            }
        }
    }

    @Override
    public void exitCompilationUnit(GroovyParser.CompilationUnitContext ctx) {
        if (ctx.getStop() != null && ctx.getStop().getStopIndex() + 1 == this.cursor) {
            String t = this.removeEOF(ctx.getText());
            this.classUtils.getClass();
            this.addQuery(this.classUtils.expandExpression(t, this.registry, 2), this.calculateStartIndex(t, ctx));
            String[] txtv = this.splitByDot(t);
            AutocompleteCandidate c2 = new AutocompleteCandidate(5, txtv);
            this.addQuery(c2, this.calculateStartIndex(t, ctx));
        }
    }

    private String removeEOF(String text) {
        return text.substring(0, text.length() - 5);
    }

    private String[] splitByDot(String t) {
        String[] txtv;
        if (t.endsWith(".")) {
            txtv = (t + "X").split("\\.");
            txtv[txtv.length - 1] = "";
        } else {
            txtv = t.split("\\.");
        }
        return txtv;
    }

    private int calculateStartIndex(String t, ParserRuleContext ctx) {
        return AutocompleteGroovyResult.getStartIndex(ctx) + (t.endsWith(".") ? 1 : 0);
    }
}

