/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.widget.DOMWidget;
import com.twosigma.beakerx.widget.Widget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Output
extends DOMWidget {
    public static final String VIEW_NAME_VALUE = "OutputView";
    public static final String MODEL_NAME_VALUE = "OutputModel";
    public static final String MODEL_MODULE_VALUE = "@jupyter-widgets/output";
    public static final String VIEW_MODULE_VALUE = "@jupyter-widgets/output";
    public static final String OUTPUTS = "outputs";
    public static final String OUTPUT_TYPE = "output_type";
    public static final String NAME = "name";
    public static final String TEXT = "text";
    public static final String STREAM = "stream";
    public static final String STDERR = "stderr";
    public static final String STDOUT = "stdout";
    private List<Map<String, Serializable>> outputs = Collections.synchronizedList(new ArrayList());

    public Output() {
        this.openComm();
    }

    @Override
    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    @Override
    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    @Override
    public String getModelModuleValue() {
        return "@jupyter-widgets/output";
    }

    @Override
    public String getViewModuleValue() {
        return "@jupyter-widgets/output";
    }

    @Override
    protected HashMap<String, Serializable> content(HashMap<String, Serializable> content) {
        super.content(content);
        content.put("msg_id", (Serializable)((Object)""));
        content.put(OUTPUTS, (Serializable)new ArrayList().toArray());
        return content;
    }

    @Override
    public void updateValue(Object value) {
    }

    public void sendStdout(String text) {
        this.send(false, text);
    }

    public void sendStderr(String text) {
        this.send(true, text);
    }

    public void appendStdout(String text) {
        this.sendStdout(text + "\n");
    }

    public void appendStderr(String text) {
        this.sendStderr(text + "\n");
    }

    private synchronized void send(boolean isError, String text) {
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(this.getComm().createUpdateMessage("msg_id", this.getComm().getParentMessage().getHeader().getId()));
        Map<String, Serializable> asMap = this.addOutput(isError, text);
        list.add(this.getComm().createOutputContent(asMap));
        list.add(this.getComm().createUpdateMessage("msg_id", ""));
        this.getComm().publish(list);
    }

    private Map<String, Serializable> addOutput(boolean isError, String text) {
        Map<String, Serializable> value = this.createOutput(isError, text);
        this.outputs.add(value);
        return value;
    }

    public void clearOutput() {
        this.outputs = Collections.synchronizedList(new ArrayList());
        this.sendUpdate(OUTPUTS, Collections.emptyList());
    }

    private Map<String, Serializable> createOutput(boolean isError, String text) {
        HashMap<String, Serializable> outputs = new HashMap<String, Serializable>();
        outputs.put(OUTPUT_TYPE, (Serializable)((Object)STREAM));
        outputs.put(NAME, (Serializable)((Object)(isError ? STDERR : STDOUT)));
        outputs.put(TEXT, (Serializable)((Object)text));
        return outputs;
    }

    public void display(MIMEContainer mimeContainer) {
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        content.put(mimeContainer.getMime().asString(), (Serializable)mimeContainer.getData());
        this.display(content);
    }

    public void display(Widget widget) {
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        HashMap<String, String> vendor = new HashMap<String, String>();
        vendor.put("model_id", widget.getComm().getCommId());
        content.put("application/vnd.jupyter.widget-view+json", vendor);
        this.display(content);
    }

    private void display(HashMap<String, Serializable> content) {
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(this.getComm().createUpdateMessage("msg_id", this.getComm().getParentMessage().getHeader().getId()));
        list.add(this.getComm().createMessage(JupyterMessages.DISPLAY_DATA, Comm.Buffer.EMPTY, new Comm.Data(content)));
        list.add(this.getComm().createUpdateMessage("msg_id", ""));
        this.getComm().publish(list);
    }
}

