/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.magic.command.CodeFactory;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecuteRequestHandler
extends KernelHandler<Message> {
    private int executionCount = 0;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);

    public ExecuteRequestHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        this.executorService.submit(() -> {
            try {
                this.handleMsg(message);
            }
            catch (Exception e) {
                this.handleException(message, e);
            }
        });
    }

    private void handleMsg(Message message) {
        this.kernel.sendBusyMessage(message);
        ++this.executionCount;
        String codeString = this.takeCodeFrom(message);
        this.announceTheCode(message, codeString);
        Code code = CodeFactory.create(codeString, message, this.kernel);
        code.execute(this.kernel, this.executionCount);
        this.finishExecution(message);
    }

    private void finishExecution(Message message) {
        this.kernel.sendIdleMessage(message);
    }

    private String takeCodeFrom(Message message) {
        String code = "";
        if (message.getContent() != null && message.getContent().containsKey("code")) {
            code = ((String)((Object)message.getContent().get("code"))).trim();
        }
        return code;
    }

    private void announceTheCode(Message message, String code) {
        Message reply = new Message();
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        reply.setHeader(new Header(JupyterMessages.EXECUTE_INPUT, message.getHeader().getSession()));
        HashMap<String, Serializable> map1 = new HashMap<String, Serializable>(2);
        map1.put("execution_count", Integer.valueOf(this.executionCount));
        map1.put("code", (Serializable)((Object)code));
        reply.setContent(map1);
        this.kernel.publish(Collections.singletonList(reply));
    }

    private void handleException(Message message, Exception e) {
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject(this.takeCodeFrom(message), this.kernel, message, this.executionCount);
        seo.error(e);
    }

    @Override
    public void exit() {
    }
}

