/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import com.twosigma.beakerx.kernel.AddImportStatus;
import com.twosigma.beakerx.kernel.ImportPath;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Imports {
    private List<ImportPath> imports;
    private List<String> importsAsStrings = null;

    public Imports(List<ImportPath> importPaths) {
        this.imports = (List)Preconditions.checkNotNull(importPaths);
    }

    public List<ImportPath> getImportPaths() {
        return this.imports;
    }

    public AddImportStatus add(ImportPath anImport, ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)anImport);
        if (this.imports.contains(anImport)) {
            return AddImportStatus.EXISTS;
        }
        if (!this.isImportPathValid(anImport, classLoader)) {
            return AddImportStatus.ERROR;
        }
        this.clear();
        this.imports.add(anImport);
        return AddImportStatus.ADDED;
    }

    public boolean remove(ImportPath anImport) {
        Preconditions.checkNotNull((Object)anImport);
        if (this.imports.contains(anImport)) {
            this.clear();
            return this.imports.remove(anImport);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.imports.isEmpty();
    }

    public List<String> toListOfStrings() {
        if (this.importsAsStrings == null) {
            this.importsAsStrings = this.importsToStrings();
        }
        return this.importsAsStrings;
    }

    private List<String> importsToStrings() {
        ArrayList<String> importsAsStrings = new ArrayList<String>();
        for (ImportPath st : this.getImportPaths()) {
            importsAsStrings.add(st.asString());
        }
        return importsAsStrings;
    }

    private void clear() {
        this.importsAsStrings = null;
    }

    public String toString() {
        return this.imports.stream().map(ImportPath::asString).collect(Collectors.joining("\n"));
    }

    private boolean isImportPathValid(ImportPath anImport, ClassLoader classLoader) {
        if (anImport.isStatic()) {
            return this.isValidStaticImport(anImport, classLoader);
        }
        return this.isValidImport(anImport, classLoader);
    }

    private boolean isValidStaticImport(ImportPath anImport, ClassLoader classLoader) {
        String importToCheck = anImport.path();
        if (!importToCheck.contains(".")) {
            return false;
        }
        if (importToCheck.endsWith(".*")) {
            return this.isValidStaticImportWithWildcard(classLoader, importToCheck);
        }
        return this.isValidStatic(classLoader, importToCheck);
    }

    private boolean isValidImport(ImportPath anImport, ClassLoader classLoader) {
        String importToCheck = anImport.path();
        if (importToCheck.endsWith(".*")) {
            return this.isValidImportWithWildcard(importToCheck, classLoader);
        }
        return this.isValidClassImport(importToCheck, classLoader);
    }

    private boolean isValidStaticImportWithWildcard(ClassLoader classLoader, String importToCheck) {
        String classImport = importToCheck.substring(0, importToCheck.lastIndexOf("."));
        return this.isValidClassImport(classImport, classLoader);
    }

    private boolean isValidStatic(ClassLoader classLoader, String importToCheck) {
        String packageImport = importToCheck.substring(0, importToCheck.lastIndexOf("."));
        boolean validClassImport = this.isValidClassImport(packageImport, classLoader);
        if (validClassImport) {
            String methodOrName = importToCheck.substring(importToCheck.lastIndexOf("."), importToCheck.length()).replaceFirst(".", "");
            if (methodOrName.isEmpty()) {
                return false;
            }
            try {
                Class<?> aClass = classLoader.loadClass(packageImport);
                List<Method> methods = this.getMethods(methodOrName, aClass);
                if (!methods.isEmpty()) {
                    return true;
                }
                List<Field> fields = this.getFields(methodOrName, aClass);
                return !fields.isEmpty();
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    private List<Field> getFields(String methodOrName, Class<?> aClass) {
        Field[] publicFields = aClass.getFields();
        return Arrays.stream(publicFields).filter(x -> x.getName().equals(methodOrName)).collect(Collectors.toList());
    }

    private List<Method> getMethods(String methodOrName, Class<?> aClass) {
        Method[] publicMethods = aClass.getMethods();
        return Arrays.stream(publicMethods).filter(x -> x.getName().equals(methodOrName)).collect(Collectors.toList());
    }

    private boolean isValidClassImport(String importToCheck, ClassLoader classLoader) {
        try {
            classLoader.loadClass(importToCheck);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isValidImportWithWildcard(String importToCheck, ClassLoader classLoader) {
        try {
            String packageWithoutWildcard = importToCheck.substring(0, importToCheck.lastIndexOf("."));
            ImmutableSet topLevelClasses = ClassPath.from((ClassLoader)classLoader).getTopLevelClasses(packageWithoutWildcard);
            return !topLevelClasses.isEmpty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

