/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.chart.Graphics;
import com.twosigma.beakerx.chart.actions.CategoryGraphicsActionObject;
import com.twosigma.beakerx.chart.actions.CombinedPlotActionObject;
import com.twosigma.beakerx.chart.actions.GraphicsActionObject;
import com.twosigma.beakerx.chart.actions.XYGraphicsActionObject;
import com.twosigma.beakerx.chart.categoryplot.CategoryPlot;
import com.twosigma.beakerx.chart.xychart.CombinedPlot;
import com.twosigma.beakerx.chart.xychart.XYChart;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.BeakerxWidget;
import com.twosigma.beakerx.widget.CommActions;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class ChartDetails
extends BeakerxWidget {
    private GraphicsActionObject details;

    public GraphicsActionObject getDetails() {
        return this.details;
    }

    public void setDetails(GraphicsActionObject details) {
        this.details = details;
    }

    @Override
    protected void openComm() {
        super.openComm();
        this.getComm().addMsgCallbackList(this::handleSetDetails, this::handleClick, this::handleKey);
    }

    private void handleSetDetails(Message message) {
        this.handleCommEventSync(message, CommActions.ACTIONDETAILS, this::onActionDetails);
    }

    private void handleClick(Message message) {
        this.handleCommEventSync(message, CommActions.ONCLICK, this::onClickAction);
    }

    private void handleKey(Message message) {
        this.handleCommEventSync(message, CommActions.ONKEY, this::onKeyAction);
    }

    private void onKeyAction(HashMap content, Message message) {
        GraphicsActionObject info = this.getDetailsFromMessage(content);
        String graphicsId = this.getGraphicsUid(content);
        Graphics g = this.getGraphicsById(this.getGraphics(info, this), graphicsId);
        if (g != null) {
            g.fireOnKey(info.getKey(), info, message);
            this.sendModel();
        }
    }

    private void onClickAction(HashMap content, Message message) {
        GraphicsActionObject info = this.getDetailsFromMessage(content);
        String graphicsId = this.getGraphicsUid(content);
        Graphics g = this.getGraphicsById(this.getGraphics(info, this), graphicsId);
        if (g != null) {
            g.fireClick(info, message);
            this.sendModel();
        }
    }

    protected void onActionDetails(HashMap content, Message message) {
        GraphicsActionObject info = this.getDetailsFromMessage(content);
        String graphicsId = this.getGraphicsUid(content);
        Graphics g = this.getGraphicsById(this.getGraphics(info, this), graphicsId);
        info.setGraphics(g);
        this.setDetails(info);
        if (CommActions.ONCLICK.equals((Object)info.getActionType())) {
            NamespaceClient.getBeaker().runByTag(info.getTag());
        } else if (CommActions.ONKEY.equals((Object)info.getActionType())) {
            NamespaceClient.getBeaker().runByTag(info.getTag());
        }
    }

    protected String getGraphicsUid(HashMap content) {
        String ret = null;
        if (content.containsKey("itemId")) {
            ret = (String)content.get("itemId");
        }
        return ret;
    }

    protected GraphicsActionObject getDetailsFromMessage(HashMap content) {
        HashMap params;
        GraphicsActionObject ret = null;
        if (content.containsKey("params") && (params = (HashMap)content.get("params")).containsKey("type")) {
            String type;
            switch (type = (String)params.get("type")) {
                case "CategoryGraphicsActionObject": {
                    GraphicsActionObject retObject = ret = new CategoryGraphicsActionObject();
                    if (params.containsKey("category")) {
                        ((CategoryGraphicsActionObject)retObject).setCategory((Integer)params.get("category"));
                    }
                    if (!params.containsKey("series")) break;
                    ((CategoryGraphicsActionObject)retObject).setSeries((Integer)params.get("series"));
                    break;
                }
                case "CombinedPlotActionObject": {
                    ret = new CombinedPlotActionObject();
                    CombinedPlotActionObject retObject = (CombinedPlotActionObject)ret;
                    if (params.containsKey("subplotIndex")) {
                        retObject.setSubplotIndex((Integer)params.get("subplotIndex"));
                    }
                    if (!params.containsKey("index")) break;
                    retObject.setIndex((Integer)params.get("index"));
                    break;
                }
                case "XYGraphicsActionObject": {
                    ret = new XYGraphicsActionObject();
                    XYGraphicsActionObject retObject = (XYGraphicsActionObject)ret;
                    if (!params.containsKey("index")) break;
                    retObject.setIndex((Integer)params.get("index"));
                }
            }
            if (params.containsKey("actionType")) {
                CommActions value = CommActions.getByAction((String)params.get("actionType"));
                ret.setActionType(value);
            }
            if (params.containsKey("tag")) {
                ret.setTag((String)params.get("tag"));
            }
            if (params.containsKey("key")) {
                ret.setKey((String)params.get("key"));
            }
        }
        return ret;
    }

    protected List<? extends Graphics> getGraphics(GraphicsActionObject info, ChartDetails chart) {
        List<Graphics> graphics = null;
        if (chart instanceof XYChart) {
            graphics = ((XYChart)chart).getGraphics();
        } else if (chart instanceof CategoryPlot) {
            graphics = ((CategoryPlot)chart).getGraphics();
        } else if (chart instanceof CombinedPlot) {
            XYChart subplot = ((CombinedPlot)chart).getSubplots().get(((CombinedPlotActionObject)info).getSubplotIndex());
            graphics = subplot.getGraphics();
        }
        return graphics;
    }

    protected Graphics getGraphicsById(List<? extends Graphics> graphicsList, String graphicsId) {
        if (graphicsList != null) {
            for (Graphics graphics : graphicsList) {
                if (!StringUtils.equals((CharSequence)graphics.getUid(), (CharSequence)graphicsId)) continue;
                return graphics;
            }
        }
        return null;
    }
}

