/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.threads;

import com.twosigma.beakerx.jvm.object.ConsoleOutput;
import com.twosigma.beakerx.jvm.threads.BeakerOutputHandler;
import com.twosigma.beakerx.widgets.Output;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class BeakerStdOutErrHandler {
    private static BeakerStdOutErrHandler instance;
    private PrintStream orig_out;
    private PrintStream orig_err;
    private BeakerOutputHandler out_handler;
    private BeakerOutputHandler err_handler;
    private Output outputWidget;

    public static synchronized void init() {
        if (instance == null) {
            instance = new BeakerStdOutErrHandler();
            instance.theinit();
        }
    }

    public static synchronized void fini() {
        if (instance != null) {
            instance.thefini();
            instance = null;
        }
    }

    public static synchronized void setOutputHandler(BeakerOutputHandler out, BeakerOutputHandler err) {
        if (instance != null) {
            instance.theSetOutputHandler(out, err);
        }
    }

    public static synchronized void clrOutputHandler() {
        if (instance != null) {
            instance.theClrOutputHandler();
        }
    }

    public static void setOuputWidget(Output out) {
        BeakerStdOutErrHandler.instance.outputWidget = out;
    }

    private void theinit() {
        this.orig_out = System.out;
        this.orig_err = System.err;
        try {
            System.setOut(new PrintStream((OutputStream)new MyOutputStream(true), false, StandardCharsets.UTF_8.name()));
            System.setErr(new PrintStream((OutputStream)new MyOutputStream(false), false, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void thefini() {
        System.setOut(this.orig_out);
        System.setErr(this.orig_err);
    }

    private synchronized void theSetOutputHandler(BeakerOutputHandler out, BeakerOutputHandler err) {
        this.out_handler = out;
        this.err_handler = err;
    }

    private synchronized void theClrOutputHandler() {
        this.out_handler = null;
        this.err_handler = null;
    }

    private BeakerOutputHandler getHandler(boolean out) {
        if (this.out_handler != null && this.err_handler != null) {
            if (out) {
                return this.out_handler;
            }
            return this.err_handler;
        }
        return null;
    }

    private synchronized void write(boolean isout, int b) throws IOException {
        if (this.outputWidget != null) {
            byte[] ba = new byte[]{(byte)b};
            this.outputWidget.sendOutput(new ConsoleOutput(!isout, new String(ba, StandardCharsets.UTF_8)));
        } else {
            BeakerOutputHandler hdl = this.getHandler(isout);
            if (hdl != null) {
                hdl.write(b);
            } else if (isout) {
                this.orig_out.write(b);
            } else {
                this.orig_err.write(b);
            }
        }
    }

    private synchronized void write(boolean isout, byte[] b) throws IOException {
        if (this.outputWidget != null) {
            this.outputWidget.sendOutput(new ConsoleOutput(!isout, new String(b, StandardCharsets.UTF_8)));
        } else {
            BeakerOutputHandler hdl = this.getHandler(isout);
            if (hdl != null) {
                hdl.write(b);
            } else if (isout) {
                this.orig_out.write(b);
            } else {
                this.orig_err.write(b);
            }
        }
    }

    private synchronized void write(boolean isout, byte[] b, int off, int len) throws IOException {
        if (this.outputWidget != null) {
            this.outputWidget.sendOutput(new ConsoleOutput(!isout, new String(b, off, len, StandardCharsets.UTF_8)));
        } else {
            BeakerOutputHandler hdl = this.getHandler(isout);
            if (hdl != null) {
                hdl.write(b, off, len);
            } else if (isout) {
                this.orig_out.write(b, off, len);
            } else {
                this.orig_err.write(b, off, len);
            }
        }
    }

    public static void clearOutput() {
        if (BeakerStdOutErrHandler.instance.outputWidget != null) {
            BeakerStdOutErrHandler.instance.outputWidget.clearOutput();
        }
    }

    private class MyOutputStream
    extends OutputStream {
        private boolean is_out;

        public MyOutputStream(boolean isout) {
            this.is_out = isout;
        }

        @Override
        public void write(int b) throws IOException {
            instance.write(this.is_out, b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            instance.write(this.is_out, b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            instance.write(this.is_out, b, off, len);
        }
    }
}

