/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widgets;

import com.twosigma.beakerx.jvm.object.ConsoleOutput;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.widgets.DOMWidget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Output
extends DOMWidget {
    public static final String VIEW_NAME_VALUE = "OutputView";
    public static final String MODEL_NAME_VALUE = "OutputModel";
    public static final String MODEL_MODULE_VALUE = "@jupyter-widgets/output";
    public static final String VIEW_MODULE_VALUE = "@jupyter-widgets/output";
    public static final String OUTPUTS = "outputs";
    public static final String OUTPUT_TYPE = "output_type";
    public static final String NAME = "name";
    public static final String TEXT = "text";
    public static final String STREAM = "stream";
    public static final String STDERR = "stderr";
    public static final String STDOUT = "stdout";
    private List<Map<String, Serializable>> outputs = Collections.synchronizedList(new ArrayList());

    public Output() {
        this.openComm();
    }

    @Override
    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    @Override
    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    @Override
    public String getModelModuleValue() {
        return "@jupyter-widgets/output";
    }

    @Override
    public String getViewModuleValue() {
        return "@jupyter-widgets/output";
    }

    @Override
    protected HashMap<String, Serializable> content(HashMap<String, Serializable> content) {
        super.content(content);
        content.put("msg_id", (Serializable)((Object)""));
        content.put(OUTPUTS, (Serializable)new ArrayList().toArray());
        return content;
    }

    @Override
    public void updateValue(Object value) {
    }

    public synchronized void sendOutput(ConsoleOutput co) {
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(this.getComm().createUpdateMessage("msg_id", this.getComm().getParentMessage().getHeader().getId()));
        Map<String, Serializable> asMap = this.addOutput(co);
        list.add(this.getComm().createOutputContent(asMap));
        list.add(this.getComm().createUpdateMessage("msg_id", ""));
        this.getComm().publish(list);
    }

    public void display(MIMEContainer mimeContainer) {
        ArrayList<Message> list = new ArrayList<Message>();
        list.add(this.getComm().createUpdateMessage("msg_id", this.getComm().getParentMessage().getHeader().getId()));
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        content.put(mimeContainer.getMime().asString(), (Serializable)mimeContainer.getData());
        list.add(this.getComm().createMessage(JupyterMessages.DISPLAY_DATA, Comm.Buffer.EMPTY, new Comm.Data(content)));
        list.add(this.getComm().createUpdateMessage("msg_id", ""));
        this.getComm().publish(list);
    }

    public void appendStdout(String text) {
        this.sendOutput(new ConsoleOutput(false, text + "\n"));
    }

    public void appendStderr(String text) {
        this.sendOutput(new ConsoleOutput(true, text + "\n"));
    }

    private Map<String, Serializable> addOutput(ConsoleOutput co) {
        Map<String, Serializable> value = this.createOutput(co);
        this.outputs.add(value);
        return value;
    }

    public void clearOutput() {
        this.outputs = Collections.synchronizedList(new ArrayList());
        this.sendUpdate(OUTPUTS, Collections.emptyList());
    }

    private Map<String, Serializable> createOutput(ConsoleOutput co) {
        HashMap<String, Serializable> outputs = new HashMap<String, Serializable>();
        outputs.put(OUTPUT_TYPE, (Serializable)((Object)STREAM));
        outputs.put(NAME, (Serializable)((Object)(co.isError() ? STDERR : STDOUT)));
        outputs.put(TEXT, (Serializable)((Object)co.getText()));
        return outputs;
    }
}

