/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.google.common.base.Preconditions;
import com.twosigma.beakerx.kernel.commands.MavenInvocationSilentOutputHandler;
import com.twosigma.beakerx.kernel.commands.MavenJarResolverSilentLogger;
import com.twosigma.beakerx.kernel.magic.command.PomFactory;
import com.twosigma.beakerx.kernel.magic.command.functionality.MvnLoggerWidget;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.InvokerLogger;

public class MavenJarResolver {
    public static final String MVN_DIR = File.separator + "mvnJars";
    public static final String POM_XML = "PomTemplateMagicCommand.xml";
    public static final List<String> GOALS = Collections.singletonList("validate");
    private final String pathToMavenRepo;
    private ResolverParams commandParams;
    private String mavenLocation;
    private PomFactory pomFactory;

    public MavenJarResolver(ResolverParams commandParams, PomFactory pomFactory) {
        this.commandParams = (ResolverParams)Preconditions.checkNotNull((Object)commandParams);
        this.pathToMavenRepo = this.getOrCreateFile(commandParams.getPathToNotebookJars()).getAbsolutePath();
        this.pomFactory = pomFactory;
    }

    public AddMvnCommandResult retrieve(String groupId, String artifactId, String version, MvnLoggerWidget progress) {
        List<Dependency> dependencies = Arrays.asList(new Dependency(groupId, artifactId, version));
        return this.retrieve(dependencies, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddMvnCommandResult retrieve(List<Dependency> dependencies, MvnLoggerWidget progress) {
        File finalPom = null;
        try {
            String pomAsString = this.pomFactory.createPom(this.pathToMavenRepo, dependencies, this.commandParams.getRepos());
            finalPom = this.saveToFile(this.commandParams.getPathToNotebookJars(), pomAsString);
            InvocationRequest request = this.createInvocationRequest();
            request.setOffline(this.commandParams.getOffline());
            request.setPomFile(finalPom);
            request.setUpdateSnapshots(true);
            Invoker invoker = this.getInvoker(progress);
            progress.display();
            InvocationResult invocationResult = invoker.execute(request);
            progress.close();
            AddMvnCommandResult addMvnCommandResult = this.getResult(invocationResult, dependencies);
            this.deletePomFolder(finalPom);
            return addMvnCommandResult;
        }
        catch (Exception e) {
            AddMvnCommandResult addMvnCommandResult = AddMvnCommandResult.error(e.getMessage());
            return addMvnCommandResult;
        }
        finally {
            this.deletePomFolder(finalPom);
        }
    }

    private File saveToFile(String pathToNotebookJars, String pomAsString) throws IOException {
        File finalPom = new File(pathToNotebookJars + "/poms/pom-" + UUID.randomUUID() + "-xml");
        FileUtils.writeStringToFile((File)finalPom, (String)pomAsString, (Charset)StandardCharsets.UTF_8);
        return finalPom;
    }

    private Invoker getInvoker(MvnLoggerWidget progress) {
        DefaultInvoker invoker = new DefaultInvoker();
        String mvn = this.findMvn();
        System.setProperty("maven.home", mvn);
        invoker.setLogger((InvokerLogger)new MavenJarResolverSilentLogger());
        invoker.setOutputHandler((InvocationOutputHandler)new MavenInvocationSilentOutputHandler(progress));
        invoker.setLocalRepositoryDirectory(this.getOrCreateFile(this.commandParams.getPathToCache()));
        return invoker;
    }

    public String findMvn() {
        if (this.mavenLocation == null) {
            if (System.getenv("M2_HOME") != null) {
                this.mavenLocation = System.getenv("M2_HOME") + "/bin/mvn";
                return this.mavenLocation;
            }
            for (String dirname : System.getenv("PATH").split(File.pathSeparator)) {
                File file = new File(dirname, "mvn");
                if (!file.isFile() || !file.canExecute()) continue;
                this.mavenLocation = file.getAbsolutePath();
                return this.mavenLocation;
            }
            throw new RuntimeException("No mvn found, please install mvn by 'conda install maven' or setup M2_HOME");
        }
        return this.mavenLocation;
    }

    private AddMvnCommandResult getResult(InvocationResult invocationResult, List<Dependency> dependencies) {
        if (invocationResult.getExitCode() != 0) {
            if (invocationResult.getExecutionException() != null) {
                return AddMvnCommandResult.error(invocationResult.getExecutionException().getMessage());
            }
            StringBuilder errorMsgBuilder = new StringBuilder("Could not resolve dependencies for:");
            for (Dependency dependency : dependencies) {
                errorMsgBuilder.append("\n").append(dependency.groupId).append(" : ").append(dependency.artifactId).append(" : ").append(dependency.version);
            }
            return AddMvnCommandResult.error(errorMsgBuilder.toString());
        }
        return AddMvnCommandResult.SUCCESS;
    }

    private InvocationRequest createInvocationRequest() {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(GOALS);
        return request;
    }

    private void deletePomFolder(File finalPom) {
        if (finalPom != null) {
            File parentFile = new File(finalPom.getParent());
            try {
                FileUtils.deleteDirectory((File)parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getPathToMavenRepo() {
        return this.pathToMavenRepo;
    }

    private File getOrCreateFile(String pathToMavenRepo) {
        File theDir = new File(pathToMavenRepo);
        if (!theDir.exists()) {
            try {
                theDir.mkdirs();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return theDir;
    }

    public static class ResolverParams {
        private String pathToCache;
        private String pathToNotebookJars;
        private boolean offline = false;
        private Map<String, String> repos = Collections.emptyMap();

        public ResolverParams(String pathToCache, String pathToNotebookJars, boolean offline) {
            this.pathToCache = (String)Preconditions.checkNotNull((Object)pathToCache);
            this.pathToNotebookJars = (String)Preconditions.checkNotNull((Object)pathToNotebookJars);
            this.offline = offline;
        }

        public ResolverParams(String pathToCache, String pathToNotebookJars, boolean offline, Map<String, String> repos) {
            this(pathToCache, pathToNotebookJars, offline);
            this.repos = repos;
        }

        public ResolverParams(String pathToCache, String pathToNotebookJars) {
            this(pathToCache, pathToNotebookJars, false);
        }

        public String getPathToCache() {
            return this.pathToCache;
        }

        public String getPathToNotebookJars() {
            return this.pathToNotebookJars;
        }

        public boolean getOffline() {
            return this.offline;
        }

        public Map<String, String> getRepos() {
            return this.repos;
        }

        public void setRepos(Map<String, String> repos) {
            this.repos = repos;
        }
    }

    public static class AddMvnCommandResult {
        public static final AddMvnCommandResult SUCCESS = new AddMvnCommandResult(true, "");
        private boolean jarRetrieved;
        private String errorMessage;

        private AddMvnCommandResult(boolean retrieved, String errorMessage) {
            this.jarRetrieved = retrieved;
            this.errorMessage = errorMessage;
        }

        public boolean isJarRetrieved() {
            return this.jarRetrieved;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public static AddMvnCommandResult success() {
            return SUCCESS;
        }

        public static AddMvnCommandResult error(String msg) {
            return new AddMvnCommandResult(false, msg);
        }
    }

    public static class Dependency {
        String groupId;
        String artifactId;
        String version;

        public Dependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

