/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.CodeFrame;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.handler.MagicCommandExecutor;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.message.Message;
import java.util.Collections;
import java.util.Optional;

public class MagicCommand
extends CodeFrame {
    private MagicCommandFunctionality magicCommandFunctionality;
    private String command;
    private String commandCodeBlock;

    public MagicCommand(MagicCommandFunctionality magicCommandFunctionality, String command, String commandCodeBlock) {
        this.magicCommandFunctionality = magicCommandFunctionality;
        this.command = command;
        this.commandCodeBlock = commandCodeBlock;
    }

    public MagicCommand(MagicCommandFunctionality magicCommandFunctionality, String command) {
        this.magicCommandFunctionality = magicCommandFunctionality;
        this.command = command;
    }

    private MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        return this.magicCommandFunctionality.execute(param);
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommandCodeBlock() {
        return this.commandCodeBlock;
    }

    @Override
    public void executeFrame(Code code, KernelFunctionality kernel, Message message, int executionCount) {
        MagicCommandOutcomeItem execute = this.execute(code, executionCount, false);
        MagicCommandExecutor.sendMagicCommandOutcome(execute, kernel, message, executionCount);
        TryResult result = execute.getResult();
        SimpleEvaluationObject seo = execute.getSimpleEvaluationObject();
        this.handleResult(seo, result);
    }

    @Override
    public void executeLastFrame(Code code, KernelFunctionality kernel, Message message, int executionCount) {
        MagicCommandOutcomeItem execute = this.execute(code, executionCount, true);
        MagicCommandExecutor.sendRepliesWithStatus(Collections.singletonList(execute), kernel, message, executionCount);
        TryResult result = execute.getResult();
        SimpleEvaluationObject seo = execute.getSimpleEvaluationObject();
        this.handleResult(seo, result);
    }

    @Override
    public Optional<MagicCommandOutcomeItem> getError() {
        return Optional.empty();
    }

    private MagicCommandOutcomeItem execute(Code code, int executionCount, boolean showResult) {
        MagicCommandExecutionParam param = new MagicCommandExecutionParam(this.getCommand(), this.getCommandCodeBlock(), executionCount, code, showResult);
        return this.execute(param);
    }
}

