/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.autocomplete;

import com.twosigma.beakerx.autocomplete.ClasspathScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroovyClasspathScanner
extends ClasspathScanner {
    protected Map<String, String> fileForClass;

    public GroovyClasspathScanner() {
        if (this.fileForClass == null) {
            this.fileForClass = new HashMap<String, String>();
        }
    }

    public GroovyClasspathScanner(String cpp) {
        super(cpp);
        if (this.fileForClass == null) {
            this.fileForClass = new HashMap<String, String>();
        }
    }

    protected void examineFile(File root, File file) {
        if (file.getName().toLowerCase().endsWith(".groovy")) {
            String cname;
            String ocname = cname = this.createGroovyClassName(root, file);
            int pIndex = cname.lastIndexOf(46);
            if (pIndex > 0) {
                String pname = cname.substring(0, pIndex + 1);
                cname = cname.substring(pIndex);
                if (!this.packages.containsKey(pname)) {
                    this.packages.put(pname, new ArrayList());
                }
                ((List)this.packages.get(pname)).add(cname);
                if (this.fileForClass == null) {
                    this.fileForClass = new HashMap<String, String>();
                }
                this.fileForClass.put(ocname, file.getAbsolutePath());
            }
        }
    }

    private String createGroovyClassName(File root, File file) {
        StringBuffer sb = new StringBuffer();
        String fileName = file.getName();
        sb.append(fileName.substring(0, fileName.lastIndexOf(".groovy")));
        for (file = file.getParentFile(); file != null && !file.equals(root); file = file.getParentFile()) {
            sb.insert(0, '.').insert(0, file.getName());
        }
        return sb.toString();
    }

    public String getFileForClass(String name) {
        return this.fileForClass.get(name);
    }
}

