/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.xychart;

import com.twosigma.beakerx.chart.ChartDetails;
import com.twosigma.beakerx.chart.ChartToJson;
import com.twosigma.beakerx.chart.xychart.XYChart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CombinedPlot
extends ChartDetails {
    private int initWidth = 640;
    private int initHeight = 480;
    private String title;
    private String xLabel;
    private List<XYChart> subplots = new ArrayList<XYChart>();
    private List<Integer> weights = new ArrayList<Integer>();
    private boolean xTickLabelsVisible = true;
    private boolean yTickLabelsVisible = true;
    private boolean autoZoom = false;

    public CombinedPlot() {
        this.openComm();
    }

    @Override
    public String getModelNameValue() {
        return "PlotModel";
    }

    @Override
    public String getViewNameValue() {
        return "PlotView";
    }

    public CombinedPlot setInitWidth(int w) {
        this.initWidth = w;
        return this;
    }

    public Integer getInitWidth() {
        return this.initWidth;
    }

    public CombinedPlot setInitHeight(int h) {
        this.initHeight = h;
        return this;
    }

    public Integer getInitHeight() {
        return this.initHeight;
    }

    public CombinedPlot setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public CombinedPlot setXLabel(String xLabel) {
        this.xLabel = xLabel;
        return this;
    }

    public CombinedPlot setxLabel(String xLabel) {
        this.xLabel = xLabel;
        return this;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public String getxLabel() {
        return this.getXLabel();
    }

    public CombinedPlot add(XYChart plot, int weight) {
        this.subplots.add(plot);
        this.weights.add(weight);
        this.sendModel();
        return this;
    }

    public CombinedPlot add(XYChart plot) {
        this.subplots.add(plot);
        this.weights.add(1);
        return this;
    }

    public CombinedPlot leftShift(Object obj) {
        if (obj instanceof XYChart) {
            this.add((XYChart)obj, 1);
        } else if (obj instanceof List && ((List)obj).size() == 2) {
            List list = (List)obj;
            XYChart plot = (XYChart)list.get(0);
            int weight = ((Number)list.get(1)).intValue();
            this.add(plot, weight);
        } else {
            throw new IllegalArgumentException("leftShift takes XYChart or List that hold a XYChart and weight");
        }
        return this;
    }

    public List<XYChart> getSubplots() {
        return this.subplots;
    }

    public List<Integer> getWeights() {
        return this.weights;
    }

    public boolean isyTickLabelsVisible() {
        return this.yTickLabelsVisible;
    }

    public boolean isYTickLabelsVisible() {
        return this.isyTickLabelsVisible();
    }

    public void setyTickLabelsVisible(boolean yTickLabelsVisible) {
        this.yTickLabelsVisible = yTickLabelsVisible;
    }

    public void setYTickLabelsVisible(boolean yTickLabelsVisible) {
        this.setyTickLabelsVisible(yTickLabelsVisible);
    }

    public boolean isxTickLabelsVisible() {
        return this.xTickLabelsVisible;
    }

    public boolean isXTickLabelsVisible() {
        return this.isxTickLabelsVisible();
    }

    public void setxTickLabelsVisible(boolean xTickLabelsVisible) {
        this.xTickLabelsVisible = xTickLabelsVisible;
    }

    public void setXTickLabelsVisible(boolean xTickLabelsVisible) {
        this.setxTickLabelsVisible(xTickLabelsVisible);
    }

    public boolean getAutoZoom() {
        return this.autoZoom;
    }

    public CombinedPlot setAutoZoom(boolean autoZoom) {
        this.autoZoom = autoZoom;
        return this;
    }

    @Override
    protected Map serializeToJsonObject() {
        return ChartToJson.toJson(this);
    }

    @Override
    protected Map serializeToJsonObject(Object item) {
        return ChartToJson.toJson(item);
    }
}

