/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;

public class AddStaticImportMagicCommand
implements MagicCommandFunctionality {
    private static final String STATIC = "static";
    public static final String ADD_STATIC_IMPORT = "%import static";
    private KernelFunctionality kernel;

    public AddStaticImportMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    @Override
    public String getMagicCommandName() {
        return ADD_STATIC_IMPORT;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 2 && commandParts[0].equals("%import") && commandParts[1].equals(STATIC);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        String[] parts = MagicCommandUtils.splitPath(command);
        if (parts.length != 3) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. ");
        }
        this.kernel.addImport(new ImportPath(parts[1] + " " + parts[2]));
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
    }
}

