/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.object;

import com.twosigma.beakerx.jvm.object.ConsoleOutput;
import com.twosigma.beakerx.jvm.object.ProgressReporting;
import com.twosigma.beakerx.jvm.threads.BeakerOutputHandler;
import com.twosigma.beakerx.jvm.threads.BeakerStdOutErrHandler;
import com.twosigma.beakerx.message.Message;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEvaluationObject
extends Observable {
    private static final Logger logger = LoggerFactory.getLogger((String)SimpleEvaluationObject.class.getName());
    private Message jupyterMessage;
    private int executionCount;
    private EvaluationStatus status;
    private final String expression;
    private Object payload;
    private BeakerOutputHandler stdout;
    private BeakerOutputHandler stderr;
    private Queue<ConsoleOutput> consoleOutput = new ConcurrentLinkedQueue<ConsoleOutput>();
    private ProgressReporting progressReporting;
    private boolean showResult = true;
    private static final int OUTPUT_QUEUE_SIZE = 20;
    private static final int MAX_LINE_LENGTH = 240;
    private int outputdataCount = 0;
    private String buildingout = "";
    private List<Object> outputdata = new ArrayList<Object>();
    private String buildingerr = "";

    public SimpleEvaluationObject(String e) {
        this.expression = e;
        this.status = EvaluationStatus.QUEUED;
    }

    public boolean isShowResult() {
        return this.showResult;
    }

    public synchronized void started() {
        this.setOutputHandler();
        this.status = EvaluationStatus.RUNNING;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void finished(Object r) {
        this.clrOutputHandler();
        this.status = EvaluationStatus.FINISHED;
        this.payload = r;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void error(Object r) {
        this.clrOutputHandler();
        this.status = EvaluationStatus.ERROR;
        this.payload = r;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void update(Object r) {
        this.status = EvaluationStatus.RUNNING;
        this.payload = r;
        this.setChanged();
        this.notifyObservers();
    }

    public String getExpression() {
        return this.expression;
    }

    public synchronized EvaluationStatus getStatus() {
        return this.status;
    }

    public synchronized Object getPayload() {
        return this.payload;
    }

    public void structuredUpdate(String message, int progress) {
        if (this.progressReporting == null) {
            this.progressReporting = new ProgressReporting();
        }
        this.progressReporting.structuredUpdate(message, progress);
    }

    public void noResult() {
        this.showResult = false;
    }

    public synchronized BeakerOutputHandler getStdOutputHandler() {
        if (this.stdout == null) {
            this.stdout = new SimpleOutputHandler(false);
        }
        return this.stdout;
    }

    public synchronized BeakerOutputHandler getStdErrorHandler() {
        if (this.stderr == null) {
            this.stderr = new SimpleOutputHandler(true);
        }
        return this.stderr;
    }

    public void setOutputHandler() {
        BeakerStdOutErrHandler.setOutputHandler(this.getStdOutputHandler(), this.getStdErrorHandler());
    }

    public void clrOutputHandler() {
        this.closeProgressUpdater();
        BeakerStdOutErrHandler.clrOutputHandler();
    }

    private void closeProgressUpdater() {
        if (this.progressReporting != null) {
            this.progressReporting.close();
            this.progressReporting = null;
        }
    }

    public Message getJupyterMessage() {
        return this.jupyterMessage;
    }

    public void setJupyterMessage(Message jupyterMessage) {
        this.jupyterMessage = jupyterMessage;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public void setExecutionCount(int executionCount) {
        this.executionCount = executionCount;
    }

    public Queue<ConsoleOutput> getConsoleOutput() {
        return this.consoleOutput;
    }

    public String toString() {
        return this.status.toString() + " Console messages size = " + this.consoleOutput.size();
    }

    public List<Object> getOutputdata() {
        return this.outputdata;
    }

    public void appendOutput(String s) {
        if (this.getSize() > 20) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.getSize() > 20) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.doAppendOutput(s);
    }

    private synchronized int getSize() {
        return this.outputdataCount;
    }

    private synchronized void doAppendOutput(String s) {
        this.buildingout = this.buildingout + s;
        String add = null;
        if (s.contains("\n")) {
            if (s.endsWith("\n")) {
                add = this.buildingout;
                this.buildingout = "";
            } else {
                add = this.buildingout.substring(0, this.buildingout.lastIndexOf(10) + 1);
                this.buildingout = this.buildingout.substring(this.buildingout.lastIndexOf(10) + 1);
            }
        }
        if (this.buildingout.length() > 240) {
            add = this.buildingout;
            this.buildingout = "";
        }
        if (add != null) {
            String[] v;
            for (String sv : v = add.split("\n")) {
                while (sv.length() > 240) {
                    String t = sv.substring(0, 240);
                    sv = sv.substring(240);
                    if (this.outputdata.size() == 0 || !(this.outputdata.get(this.outputdata.size() - 1) instanceof EvaluationStdOutput)) {
                        this.outputdata.add(new EvaluationStdOutput(t + "\n"));
                    } else {
                        EvaluationStdOutput st = (EvaluationStdOutput)this.outputdata.get(this.outputdata.size() - 1);
                        st.payload = st.payload + t + "\n";
                    }
                    ++this.outputdataCount;
                }
                if (this.outputdata.size() == 0 || !(this.outputdata.get(this.outputdata.size() - 1) instanceof EvaluationStdOutput)) {
                    this.outputdata.add(new EvaluationStdOutput(sv + "\n"));
                } else {
                    EvaluationStdOutput st = (EvaluationStdOutput)this.outputdata.get(this.outputdata.size() - 1);
                    st.payload = st.payload + sv + "\n";
                }
                ++this.outputdataCount;
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void appendError(String s) {
        if (this.getSize() > 20) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.getSize() > 20) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.doAppendError(s);
    }

    private synchronized void doAppendError(String s) {
        this.buildingerr = this.buildingerr + s;
        String add = null;
        if (s.contains("\n")) {
            if (s.endsWith("\n")) {
                add = this.buildingerr;
                this.buildingerr = "";
            } else {
                add = this.buildingerr.substring(0, this.buildingerr.lastIndexOf(10) + 1);
                this.buildingerr = this.buildingerr.substring(this.buildingerr.lastIndexOf(10) + 1);
            }
        }
        if (this.buildingerr.length() > 240) {
            add = this.buildingerr;
            this.buildingerr = "";
        }
        if (add != null) {
            String[] v;
            if (add.contains("org.antlr.v4.runtime.misc.NullUsageProcessor") && add.contains("'RELEASE_6'") || add.contains("JavaSourceCompilerImpl compile")) {
                v = add.split("\n");
                add = "";
                for (String s2 : v) {
                    if (s2.contains("org.antlr.v4.runtime.misc.NullUsageProcessor") || s2.contains("JavaSourceCompilerImpl compile")) continue;
                    add = add + s2 + "\n";
                }
            }
            for (String sv : v = add.split("\n")) {
                while (sv.length() > 240) {
                    String t = sv.substring(0, 240);
                    sv = sv.substring(240);
                    if (this.outputdata.size() == 0 || !(this.outputdata.get(this.outputdata.size() - 1) instanceof EvaluationStdError)) {
                        this.outputdata.add(new EvaluationStdError(t + "\n"));
                    } else {
                        EvaluationStdError st = (EvaluationStdError)this.outputdata.get(this.outputdata.size() - 1);
                        st.payload = st.payload + t + "\n";
                    }
                    ++this.outputdataCount;
                }
                if (this.outputdata.size() == 0 || !(this.outputdata.get(this.outputdata.size() - 1) instanceof EvaluationStdError)) {
                    this.outputdata.add(new EvaluationStdError(sv + "\n"));
                } else {
                    EvaluationStdError st = (EvaluationStdError)this.outputdata.get(this.outputdata.size() - 1);
                    st.payload = st.payload + sv + "\n";
                }
                ++this.outputdataCount;
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public class EvaluationStdError {
        public String payload;

        public EvaluationStdError(String s) {
            this.payload = s;
        }
    }

    public class EvaluationStdOutput {
        public String payload;

        public EvaluationStdOutput(String s) {
            this.payload = s;
        }
    }

    public class SimpleOutputHandler
    implements BeakerOutputHandler {
        private boolean error;

        public SimpleOutputHandler(boolean error) {
            this.error = error;
        }

        @Override
        public void write(int b) {
            byte[] ba = new byte[]{(byte)b};
            SimpleEvaluationObject.this.consoleOutput.add(new ConsoleOutput(this.error, new String(ba, StandardCharsets.UTF_8)));
            SimpleEvaluationObject.this.setChanged();
            SimpleEvaluationObject.this.notifyObservers();
        }

        @Override
        public void write(byte[] b) {
            SimpleEvaluationObject.this.consoleOutput.add(new ConsoleOutput(this.error, new String(b, StandardCharsets.UTF_8)));
            SimpleEvaluationObject.this.setChanged();
            SimpleEvaluationObject.this.notifyObservers();
        }

        @Override
        public void write(byte[] b, int off, int len) {
            SimpleEvaluationObject.this.consoleOutput.add(new ConsoleOutput(this.error, new String(b, off, len, StandardCharsets.UTF_8)));
            SimpleEvaluationObject.this.setChanged();
            SimpleEvaluationObject.this.notifyObservers();
        }
    }

    public static enum EvaluationStatus {
        QUEUED,
        RUNNING,
        FINISHED,
        ERROR;

    }
}

