/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.sql.ReadVariableException;
import com.twosigma.beakerx.sql.evaluator.SQLEvaluator;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SQLCodeRunner
implements Callable<TryResult> {
    private static final Logger logger = LoggerFactory.getLogger((String)SQLCodeRunner.class.getName());
    private SQLEvaluator sqlEvaluator;
    private final SimpleEvaluationObject simpleEvaluationObject;
    private final NamespaceClient namespaceClient;

    SQLCodeRunner(SQLEvaluator sqlEvaluator, SimpleEvaluationObject seo, NamespaceClient namespaceClient) {
        this.sqlEvaluator = sqlEvaluator;
        this.simpleEvaluationObject = seo;
        this.namespaceClient = namespaceClient;
    }

    @Override
    public TryResult call() throws Exception {
        TryResult.CellError either;
        try {
            InternalVariable.setValue((SimpleEvaluationObject)this.simpleEvaluationObject);
            Object r = this.sqlEvaluator.executeQuery(this.simpleEvaluationObject.getExpression(), this.namespaceClient, this.sqlEvaluator.defaultConnectionString, this.sqlEvaluator.namedConnectionString);
            either = TryResult.createResult((Object)r);
        }
        catch (SQLException e) {
            either = TryResult.createError((String)e.toString());
        }
        catch (ThreadDeath e) {
            either = TryResult.createError((String)BaseEvaluator.INTERUPTED_MSG);
        }
        catch (ReadVariableException e) {
            either = TryResult.createError((String)e.getMessage());
        }
        catch (Throwable e) {
            logger.error(e.getMessage());
            either = TryResult.createError((String)e.toString());
        }
        return either;
    }
}

