/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.io.Bits;
import org.jetbrains.kotlin.com.intellij.util.io.IOStatistics;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.kotlin.com.intellij.util.io.ResizeableMappedFile;

public class PersistentEnumerator<Data>
extends PersistentEnumeratorBase<Data> {
    private static final byte[] EMPTY_VECTOR = new byte[64];
    private static final byte[] FIRST_VECTOR = new byte[16384];
    private int valuesCount;
    private static final PersistentEnumeratorBase.Version ourVersion = new PersistentEnumeratorBase.Version(6);

    public PersistentEnumerator(@NotNull File file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator", "<init>"));
        }
        if (dataDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDescriptor", "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator", "<init>"));
        }
        this(file, dataDescriptor, initialSize, null, 0);
    }

    public PersistentEnumerator(@NotNull File file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable PagedFileStorage.StorageLockContext storageLockContext, int version) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator", "<init>"));
        }
        if (dataDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDescriptor", "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator", "<init>"));
        }
        super(file, new ResizeableMappedFile(file, initialSize, storageLockContext, -1, false), dataDescriptor, initialSize, new PersistentEnumeratorBase.Version(6 + version), new RecordBufferHandler(), true);
    }

    @Override
    protected void setupEmptyFile() throws IOException {
        this.allocVector(FIRST_VECTOR);
    }

    @Override
    public synchronized boolean traverseAllRecords(@NotNull PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator", "traverseAllRecords"));
        }
        return this.traverseRecords(20, 4096, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean traverseRecords(int vectorStart, int slotsCount, @NotNull PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator", "traverseRecords"));
        }
        this.lockStorage();
        try {
            for (int slotIdx = 0; slotIdx < slotsCount; ++slotIdx) {
                int vector = this.myStorage.getInt(vectorStart + slotIdx * 4);
                if (vector < 0) {
                    int record2 = -vector;
                    while (record2 != 0) {
                        if (!p.process(record2)) {
                            boolean bl = false;
                            return bl;
                        }
                        record2 = this.nextCanditate(record2);
                    }
                    continue;
                }
                if (vector <= 0 || this.traverseRecords(vector, 16, p)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlockStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized int enumerateImpl(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        this.lockStorage();
        try {
            int newId;
            block16: {
                int candidateHC;
                int pos;
                int lastVector;
                int valueHC;
                int depth = 0;
                int hc = valueHC = this.myDataDescriptor.getHashCode(value);
                int vector = 20;
                int levelMask = 4095;
                int bitsPerLevel = 12;
                do {
                    lastVector = vector;
                    pos = vector + (hc & levelMask) * 4;
                    hc >>>= bitsPerLevel;
                    vector = this.myStorage.getInt(pos);
                    ++depth;
                    levelMask = 15;
                    bitsPerLevel = 4;
                } while (vector > 0);
                if (vector == 0) {
                    if (onlyCheckForExisting) {
                        int n = 0;
                        return n;
                    }
                    int newId2 = this.writeData(value, valueHC);
                    this.myStorage.putInt(pos, -newId2);
                    int n = newId2;
                    return n;
                }
                int collision = -vector;
                boolean splitVector = false;
                do {
                    if ((candidateHC = this.hashCodeOf(collision)) != valueHC) {
                        splitVector = true;
                        break;
                    }
                    Object candidate = this.valueOf(collision);
                    if (!this.myDataDescriptor.isEqual(value, candidate)) continue;
                    int n = collision;
                    return n;
                } while ((collision = this.nextCanditate(collision)) != 0);
                if (onlyCheckForExisting) {
                    int candidate = 0;
                    return candidate;
                }
                newId = this.writeData(value, valueHC);
                if (splitVector) {
                    --depth;
                    while (true) {
                        int oldHCByte;
                        int valueHCByte;
                        if ((valueHCByte = PersistentEnumerator.hcByte(valueHC, depth)) != (oldHCByte = PersistentEnumerator.hcByte(candidateHC, depth))) {
                            this.myStorage.putInt(lastVector + valueHCByte * 4, -newId);
                            this.myStorage.putInt(lastVector + oldHCByte * 4, vector);
                            break block16;
                        }
                        int newVector = this.allocVector(EMPTY_VECTOR);
                        this.myStorage.putInt(lastVector + oldHCByte * 4, newVector);
                        lastVector = newVector;
                        ++depth;
                    }
                }
                this.myStorage.putInt(newId, vector);
                this.myStorage.putInt(pos, -newId);
            }
            int n = newId;
            return n;
        }
        finally {
            this.unlockStorage();
        }
    }

    @Override
    protected int writeData(Data value, int hashCode) {
        int id = super.writeData(value, hashCode);
        ++this.valuesCount;
        if (IOStatistics.DEBUG && (this.valuesCount & 0xFFFF) == 0) {
            IOStatistics.dump("Index " + this.myFile + ", values " + this.valuesCount + ", storage size:" + this.myStorage.length());
        }
        return id;
    }

    private static int hcByte(int hashcode, int byteN) {
        if (byteN == 0) {
            return hashcode & 0xFFF;
        }
        return (hashcode >>>= 12) >>> --byteN * 4 & 0xF;
    }

    private int allocVector(@NotNull byte[] empty) throws IOException {
        if (empty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "empty", "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator", "allocVector"));
        }
        int pos = (int)this.myStorage.length();
        this.myStorage.put(pos, empty, 0, empty.length);
        return pos;
    }

    private int nextCanditate(int idx) throws IOException {
        return -this.myStorage.getInt(idx);
    }

    private int hashCodeOf(int idx) throws IOException {
        return this.myStorage.getInt(idx + 4);
    }

    @Override
    protected int indexToAddr(int idx) {
        return this.myStorage.getInt(idx + 8);
    }

    private static class RecordBufferHandler
    extends PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumerator> {
        private final byte[] myBuffer = new byte[12];

        private RecordBufferHandler() {
        }

        @Override
        protected int recordWriteOffset(@NotNull PersistentEnumerator enumerator, byte[] buf) {
            if (enumerator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumerator", "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator$RecordBufferHandler", "recordWriteOffset"));
            }
            return (int)enumerator.myStorage.length();
        }

        @Override
        @NotNull
        byte[] getRecordBuffer(PersistentEnumerator t) {
            if (this.myBuffer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator$RecordBufferHandler", "getRecordBuffer"));
            }
            return this.myBuffer;
        }

        @Override
        void setupRecord(PersistentEnumerator enumerator, int hashCode, int dataOffset, byte[] buf) {
            Bits.putInt(buf, 0, 0);
            Bits.putInt(buf, 4, hashCode);
            Bits.putInt(buf, 8, dataOffset);
        }
    }
}

